"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoMatchDataMessage = exports.MissingPatternsMessage = exports.DeprecatedMessage = exports.CurrentPatternsMessage = exports.BadCurrentPatternsMessage = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _timeline = require("../../../common/api/timeline");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CurrentPatternsMessage = ({
  activePatterns,
  deadPatterns,
  selectedPatterns,
  timelineType
}) => {
  const tooltip = (0, _react.useMemo)(() => deadPatterns.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(NoMatchDataMessage, {
      activePatterns: activePatterns,
      selectedPatterns: selectedPatterns,
      timelineType: timelineType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 13
      }
    }),
    type: "question",
    title: i18n.INACTIVE_PATTERNS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }) : null, [activePatterns, deadPatterns.length, selectedPatterns, timelineType]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-current-patterns-message",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatterns",
      defaultMessage: "The active index patterns in this timeline template are{tooltip}: {callout}",
      values: {
        tooltip,
        callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 22
          }
        }, activePatterns.join(', '))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-current-patterns-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatterns",
    defaultMessage: "The active index patterns in this timeline are{tooltip}: {callout}",
    values: {
      tooltip,
      callout: /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 20
        }
      }, activePatterns.join(', '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.CurrentPatternsMessage = CurrentPatternsMessage;
const NoMatchDataMessage = ({
  activePatterns,
  selectedPatterns,
  timelineType
}) => {
  const aliases = (0, _react.useMemo)(() => selectedPatterns.filter(p => !activePatterns.includes(p)).join(', '), [activePatterns, selectedPatterns]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.noMatchData",
      defaultMessage: "The following index patterns are saved to this timeline template but do not match any data streams, indices, or index aliases: {aliases}",
      values: {
        aliases
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.noMatchData",
    defaultMessage: "The following index patterns are saved to this timeline but do not match any data streams, indices, or index aliases: {aliases}",
    values: {
      aliases
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  });
};
exports.NoMatchDataMessage = NoMatchDataMessage;
const BadCurrentPatternsMessage = ({
  timelineType,
  selectedPatterns
}) => {
  const callout = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_helpers.Blockquote, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, selectedPatterns.join(', ')), [selectedPatterns]);
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.currentPatternsBad",
      defaultMessage: "The current index patterns in this timeline template are: {callout}",
      values: {
        callout
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.currentPatternsBad",
    defaultMessage: "The current index patterns in this timeline are: {callout}",
    values: {
      callout
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  });
};
exports.BadCurrentPatternsMessage = BadCurrentPatternsMessage;
const DeprecatedMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-deprecated-message",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.timelineTemplate.toggleToNewSourcerer",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 19
          }
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-deprecated-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.timeline.toggleToNewSourcerer",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can recreate your temporary data view with the new data view selector. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 17
        }
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }));
};
exports.DeprecatedMessage = DeprecatedMessage;
const MissingPatternsMessage = ({
  onReset,
  timelineType
}) => {
  if (timelineType === _timeline.TimelineTypeEnum.template) {
    return /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "sourcerer-missing-patterns-message",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.indexPatterns.missingPatterns.timelineTemplate.description",
      defaultMessage: "We have preserved your timeline template by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: onReset,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 190,
            columnNumber: 19
          }
        }, i18n.TOGGLE_TO_NEW_SOURCERER)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "sourcerer-missing-patterns-message",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.indexPatterns.missingPatterns.timeline.description",
    defaultMessage: "We have preserved your timeline by creating a temporary data view. If you'd like to modify your data, we can add the missing index patterns to the Security Data View. You can also manually select a data view {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onReset,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 17
        }
      }, i18n.TOGGLE_TO_NEW_SOURCERER)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }));
};
exports.MissingPatternsMessage = MissingPatternsMessage;