"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetMigrationPrebuiltRules = void 0;
var _shared = require("@kbn/openapi-common/shared");
var _reactQuery = require("@kbn/react-query");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _constants = require("../../../../common/siem_migrations/constants");
var _api = require("../api");
var _constants2 = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetMigrationPrebuiltRules = migrationId => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const SPECIFIC_MIGRATIONS_PREBUILT_RULES_PATH = (0, _shared.replaceParams)(_constants.SIEM_RULE_MIGRATIONS_PREBUILT_RULES_PATH, {
    migration_id: migrationId
  });
  return (0, _reactQuery.useQuery)(['GET', SPECIFIC_MIGRATIONS_PREBUILT_RULES_PATH], async ({
    signal
  }) => {
    return (0, _api.getRuleMigrationsPrebuiltRules)({
      migrationId,
      signal
    });
  }, {
    ..._constants2.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.GET_MIGRATION_PREBUILT_RULES_FAILURE
      });
    }
  });
};
exports.useGetMigrationPrebuiltRules = useGetMigrationPrebuiltRules;