"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_MIGRATION_VIEW_TRANSLATED_RULES_BUTTON = exports.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = exports.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = exports.RULE_MIGRATION_UPLOAD_BUTTON = exports.RULE_MIGRATION_TRANSLATION_FAILED = exports.RULE_MIGRATION_TRANSLATING = exports.RULE_MIGRATION_TABLE_COLUMN_STATUS = exports.RULE_MIGRATION_TABLE_COLUMN_RULES = exports.RULE_MIGRATION_SUMMARY_TITLE = exports.RULE_MIGRATION_SUMMARY_CHART_TITLE = exports.RULE_MIGRATION_STOP_TRANSLATION_BUTTON = exports.RULE_MIGRATION_STOPPING_TRANSLATION_BUTTON = exports.RULE_MIGRATION_STOPPED_DESCRIPTION = exports.RULE_MIGRATION_READY_MISSING_RESOURCES = exports.RULE_MIGRATION_READY_DESCRIPTION = exports.RULE_MIGRATION_PROGRESS_DESCRIPTION = exports.RULE_MIGRATION_PREPARING = exports.RULE_MIGRATION_IN_PROGRESS_BADGE = exports.RULE_MIGRATION_EXPAND = exports.RULE_MIGRATION_ERROR_TITLE = exports.RULE_MIGRATION_ERROR_DESCRIPTION = exports.RULE_MIGRATION_COMPLETE_DESCRIPTION = exports.RULE_MIGRATION_COMPLETE_BADGE = exports.RULE_MIGRATION_COLLAPSE = exports.RENAME_MIGRATION_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_MIGRATION_READY_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.ready.description', {
  defaultMessage: 'Migration of {totalRules} rules is created and ready to start.',
  values: {
    totalRules
  }
});
exports.RULE_MIGRATION_READY_DESCRIPTION = RULE_MIGRATION_READY_DESCRIPTION;
const RULE_MIGRATION_ERROR_DESCRIPTION = totalRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.error.description', {
    defaultMessage: 'Migration of {totalRules} rules failed. Please correct the below error and try again.',
    values: {
      totalRules
    }
  });
};
exports.RULE_MIGRATION_ERROR_DESCRIPTION = RULE_MIGRATION_ERROR_DESCRIPTION;
const RULE_MIGRATION_STOPPED_DESCRIPTION = totalRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.stopped.description', {
    defaultMessage: 'Migration of {totalRules} rules was stopped, you can resume it any time.',
    values: {
      totalRules
    }
  });
};
exports.RULE_MIGRATION_STOPPED_DESCRIPTION = RULE_MIGRATION_STOPPED_DESCRIPTION;
const RULE_MIGRATION_READY_MISSING_RESOURCES = exports.RULE_MIGRATION_READY_MISSING_RESOURCES = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.ready.missingResources', {
  defaultMessage: 'You can also upload the missing macros & lookups for more accurate results.'
});
const RULE_MIGRATION_STOP_TRANSLATION_BUTTON = exports.RULE_MIGRATION_STOP_TRANSLATION_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.translate.stopButton', {
  defaultMessage: 'Stop'
});
const RULE_MIGRATION_STOPPING_TRANSLATION_BUTTON = exports.RULE_MIGRATION_STOPPING_TRANSLATION_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.translate.stoppingButton', {
  defaultMessage: 'Stopping'
});
const RULE_MIGRATION_PROGRESS_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.progress.description', {
  defaultMessage: `Processing migration of {totalRules} rules.`,
  values: {
    totalRules
  }
});
exports.RULE_MIGRATION_PROGRESS_DESCRIPTION = RULE_MIGRATION_PROGRESS_DESCRIPTION;
const RULE_MIGRATION_IN_PROGRESS_BADGE = exports.RULE_MIGRATION_IN_PROGRESS_BADGE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.progress.badge', {
  defaultMessage: `Translation in progress`
});
const RULE_MIGRATION_PREPARING = exports.RULE_MIGRATION_PREPARING = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.progress.preparing', {
  defaultMessage: `Preparing environment for the AI powered translation.`
});
const RULE_MIGRATION_TRANSLATING = exports.RULE_MIGRATION_TRANSLATING = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.progress.translating', {
  defaultMessage: `Translating rules`
});
const RULE_MIGRATION_COMPLETE_DESCRIPTION = (createdAt, finishedAt) => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.description', {
  defaultMessage: 'Export uploaded on {createdAt} and translation finished {finishedAt}.',
  values: {
    createdAt,
    finishedAt
  }
});
exports.RULE_MIGRATION_COMPLETE_DESCRIPTION = RULE_MIGRATION_COMPLETE_DESCRIPTION;
const RULE_MIGRATION_COMPLETE_BADGE = exports.RULE_MIGRATION_COMPLETE_BADGE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.badge', {
  defaultMessage: `Translation complete`
});
const RULE_MIGRATION_SUMMARY_TITLE = exports.RULE_MIGRATION_SUMMARY_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.title', {
  defaultMessage: 'Translation Summary'
});
const RULE_MIGRATION_SUMMARY_CHART_TITLE = exports.RULE_MIGRATION_SUMMARY_CHART_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.chartTitle', {
  defaultMessage: 'Rules by translation status'
});
const RULE_MIGRATION_VIEW_TRANSLATED_RULES_BUTTON = exports.RULE_MIGRATION_VIEW_TRANSLATED_RULES_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.button', {
  defaultMessage: 'View rules'
});
const RULE_MIGRATION_TRANSLATION_FAILED = exports.RULE_MIGRATION_TRANSLATION_FAILED = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.failed', {
  defaultMessage: 'Failed'
});
const RULE_MIGRATION_TABLE_COLUMN_STATUS = exports.RULE_MIGRATION_TABLE_COLUMN_STATUS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.tableColumn.status', {
  defaultMessage: 'Status'
});
const RULE_MIGRATION_TABLE_COLUMN_RULES = exports.RULE_MIGRATION_TABLE_COLUMN_RULES = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.result.summary.tableColumn.rules', {
  defaultMessage: 'Rules'
});
const RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = exports.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.uploadMissingResources', {
  defaultMessage: 'Upload missing macros and lookup lists.'
});
const RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = exports.RULE_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.uploadMissingResourcesDescription', {
  defaultMessage: 'Click Upload to continue translating rules'
});
const RULE_MIGRATION_UPLOAD_BUTTON = exports.RULE_MIGRATION_UPLOAD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.uploadMacros.button', {
  defaultMessage: 'Upload'
});
const RULE_MIGRATION_EXPAND = exports.RULE_MIGRATION_EXPAND = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.expand', {
  defaultMessage: 'Expand rule migration'
});
const RULE_MIGRATION_COLLAPSE = exports.RULE_MIGRATION_COLLAPSE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.collapse', {
  defaultMessage: 'Collapse rule migration'
});
const RULE_MIGRATION_ERROR_TITLE = exports.RULE_MIGRATION_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.error', {
  defaultMessage: 'The last execution of this migration failed with the following message:'
});
const RENAME_MIGRATION_BUTTON = exports.RENAME_MIGRATION_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.panel.renameMigrationButton', {
  defaultMessage: 'Rename'
});