"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrationDashboardsTableColumns = void 0;
var _react = require("react");
var _dashboard_table_columns = require("../components/dashboard_table_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMigrationDashboardsTableColumns = ({
  installDashboard,
  openDashboardDetailsFlyout,
  shouldDisableActions
}) => {
  return (0, _react.useMemo)(() => [(0, _dashboard_table_columns.createNameColumn)({
    openDashboardDetailsFlyout
  }), (0, _dashboard_table_columns.createUpdatedColumn)(), (0, _dashboard_table_columns.createStatusColumn)(), (0, _dashboard_table_columns.createTagsColumn)(), (0, _dashboard_table_columns.createActionsColumn)({
    shouldDisableActions,
    installDashboard
  })], [installDashboard, openDashboardDetailsFlyout, shouldDisableActions]);
};
exports.useMigrationDashboardsTableColumns = useMigrationDashboardsTableColumns;