"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARD_MIGRATION_VIEW_TRANSLATED_DASHBOARDS_BUTTON = exports.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = exports.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = exports.DASHBOARD_MIGRATION_UPLOAD_BUTTON = exports.DASHBOARD_MIGRATION_TRANSLATION_FAILED = exports.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS = exports.DASHBOARD_MIGRATION_TABLE_COLUMN_DASHBOARDS = exports.DASHBOARD_MIGRATION_SUMMARY_TITLE = exports.DASHBOARD_MIGRATION_SUMMARY_CHART_TITLE = exports.DASHBOARD_MIGRATION_STOPPED_DESCRIPTION = exports.DASHBOARD_MIGRATION_READY_MISSING_RESOURCES = exports.DASHBOARD_MIGRATION_READY_DESCRIPTION = exports.DASHBOARD_MIGRATION_EXPAND = exports.DASHBOARD_MIGRATION_ERROR_DESCRIPTION = exports.DASHBOARD_MIGRATION_COMPLETE_DESCRIPTION = exports.DASHBOARD_MIGRATION_COMPLETE_BADGE = exports.DASHBOARD_MIGRATION_COLLAPSE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARD_MIGRATION_READY_DESCRIPTION = totaldashboards => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.ready.description', {
  defaultMessage: 'Migration of {totaldashboards} dashboards is created and ready to start.',
  values: {
    totaldashboards
  }
});
exports.DASHBOARD_MIGRATION_READY_DESCRIPTION = DASHBOARD_MIGRATION_READY_DESCRIPTION;
const DASHBOARD_MIGRATION_ERROR_DESCRIPTION = totaldashboards => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.error.description', {
    defaultMessage: 'Migration of {totaldashboards} dashboards failed. Please correct the below error and try again.',
    values: {
      totaldashboards
    }
  });
};
exports.DASHBOARD_MIGRATION_ERROR_DESCRIPTION = DASHBOARD_MIGRATION_ERROR_DESCRIPTION;
const DASHBOARD_MIGRATION_STOPPED_DESCRIPTION = totaldashboards => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.stopped.description', {
    defaultMessage: 'Migration of {totaldashboards} dashboards was stopped, you can resume it any time.',
    values: {
      totaldashboards
    }
  });
};
exports.DASHBOARD_MIGRATION_STOPPED_DESCRIPTION = DASHBOARD_MIGRATION_STOPPED_DESCRIPTION;
const DASHBOARD_MIGRATION_READY_MISSING_RESOURCES = exports.DASHBOARD_MIGRATION_READY_MISSING_RESOURCES = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.ready.missingResources', {
  defaultMessage: 'You can also upload the missing macros & lookups for more accurate results.'
});
const DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = exports.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.uploadMissingResources', {
  defaultMessage: 'Upload missing macros and lookup lists.'
});
const DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = exports.DASHBOARD_MIGRATION_UPLOAD_MISSING_RESOURCES_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.uploadMissingResourcesDescription', {
  defaultMessage: 'Click Upload to continue translating dashboards'
});
const DASHBOARD_MIGRATION_UPLOAD_BUTTON = exports.DASHBOARD_MIGRATION_UPLOAD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.uploadMacros.button', {
  defaultMessage: 'Upload'
});
const DASHBOARD_MIGRATION_COMPLETE_DESCRIPTION = (createdAt, finishedAt) => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.description', {
  defaultMessage: 'Export uploaded on {createdAt} and translation finished {finishedAt}.',
  values: {
    createdAt,
    finishedAt
  }
});
exports.DASHBOARD_MIGRATION_COMPLETE_DESCRIPTION = DASHBOARD_MIGRATION_COMPLETE_DESCRIPTION;
const DASHBOARD_MIGRATION_COMPLETE_BADGE = exports.DASHBOARD_MIGRATION_COMPLETE_BADGE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.badge', {
  defaultMessage: `Translation complete`
});
const DASHBOARD_MIGRATION_SUMMARY_TITLE = exports.DASHBOARD_MIGRATION_SUMMARY_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.title', {
  defaultMessage: 'Translation Summary'
});
const DASHBOARD_MIGRATION_SUMMARY_CHART_TITLE = exports.DASHBOARD_MIGRATION_SUMMARY_CHART_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.chartTitle', {
  defaultMessage: 'Dashboards by translation status'
});
const DASHBOARD_MIGRATION_VIEW_TRANSLATED_DASHBOARDS_BUTTON = exports.DASHBOARD_MIGRATION_VIEW_TRANSLATED_DASHBOARDS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.button', {
  defaultMessage: 'View dashboards'
});
const DASHBOARD_MIGRATION_TRANSLATION_FAILED = exports.DASHBOARD_MIGRATION_TRANSLATION_FAILED = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.failed', {
  defaultMessage: 'Failed'
});
const DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS = exports.DASHBOARD_MIGRATION_TABLE_COLUMN_STATUS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.tableColumn.status', {
  defaultMessage: 'Status'
});
const DASHBOARD_MIGRATION_TABLE_COLUMN_DASHBOARDS = exports.DASHBOARD_MIGRATION_TABLE_COLUMN_DASHBOARDS = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.result.summary.tableColumn.dashboards', {
  defaultMessage: 'Dashboards'
});
const DASHBOARD_MIGRATION_EXPAND = exports.DASHBOARD_MIGRATION_EXPAND = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.expand', {
  defaultMessage: 'Expand dashboard migration'
});
const DASHBOARD_MIGRATION_COLLAPSE = exports.DASHBOARD_MIGRATION_COLLAPSE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboards.panel.collapse', {
  defaultMessage: 'Collapse dashboard migration'
});