"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFilterOptions = void 0;
var _types = require("../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_FILTERS = {
  [_types.StatusFilterBase.FAILED]: {
    failed: true
  },
  [_types.StatusFilterBase.INSTALLED]: {
    installed: true
  },
  [_types.StatusFilterBase.TRANSLATED]: {
    installed: false,
    fullyTranslated: true
  },
  [_types.StatusFilterBase.PARTIALLY_TRANSLATED]: {
    installed: false,
    partiallyTranslated: true
  },
  [_types.StatusFilterBase.UNTRANSLATABLE]: {
    untranslatable: true
  }
};
const convertFilterOptions = filterOptions => {
  const filters = {};
  if (filterOptions !== null && filterOptions !== void 0 && filterOptions.status) {
    Object.assign(filters, STATUS_FILTERS[filterOptions.status]);
  }
  return filters;
};
exports.convertFilterOptions = convertFilterOptions;