"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _missing_privileges = require("../../../../common/components/missing_privileges");
var _bulk_actions = require("../../../../common/components/bulk_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_table/bulk_actions/bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReprocessFailedDashboardsButton = (0, _missing_privileges.WithMissingPrivilegesTooltip)(_bulk_actions.ReprocessFailedItemsButton, 'dashboard', 'all');
/**
 * Collection of buttons to perform bulk actions on migration dashboards within the SIEM Dashboards Migrations table.
 */
const BulkActions = exports.BulkActions = /*#__PURE__*/(0, _react.memo)(({
  isTableLoading,
  translationStats,
  selectedDashboards,
  installTranslatedDashboards,
  installSelectedDashboards,
  reprocessFailedDashboards
}) => {
  const numberOfFailedDashboards = translationStats.dashboards.failed;
  const numberOfTranslatedDashboards = translationStats.dashboards.success.installable;
  const showInstallSelectedDashboardsButton = numberOfTranslatedDashboards > 0;
  const showRetryFailedDashboardsButton = numberOfFailedDashboards > 0;
  const reprocessFailedDashboardsCallback = (0, _react.useCallback)(() => {
    reprocessFailedDashboards === null || reprocessFailedDashboards === void 0 ? void 0 : reprocessFailedDashboards();
  }, [reprocessFailedDashboards]);
  const installTranslatedDashboardsCallback = (0, _react.useCallback)(() => {
    installTranslatedDashboards === null || installTranslatedDashboards === void 0 ? void 0 : installTranslatedDashboards();
  }, [installTranslatedDashboards]);
  const installSelectedDashboardsCallback = (0, _react.useCallback)(() => {
    installSelectedDashboards === null || installSelectedDashboards === void 0 ? void 0 : installSelectedDashboards();
  }, [installSelectedDashboards]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true,
    "data-test-subj": "migrationsBulkActions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, showRetryFailedDashboardsButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ReprocessFailedDashboardsButton, {
    isDisabled: isTableLoading,
    isLoading: isTableLoading,
    numberOfFailedItems: numberOfFailedDashboards,
    onClick: reprocessFailedDashboardsCallback,
    selectedItems: selectedDashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  })), showInstallSelectedDashboardsButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_bulk_actions.InstallTranslatedButton, {
    disableInstallTranslatedItemsButton: isTableLoading,
    installSelectedItem: installSelectedDashboardsCallback,
    installTranslatedItems: installTranslatedDashboardsCallback,
    isLoading: isTableLoading,
    numberOfTranslatedItems: numberOfTranslatedDashboards,
    selectedItems: selectedDashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  })));
});
BulkActions.displayName = 'BulkActions';