"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translation = require("../../../common/components/details_flyout/translation");
var _utils = require("../../../common/components/details_flyout/utils");
var _summary = require("./tabs/summary");
var _updated_by_label = require("../../../common/components/updated_by_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_details_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardMigrationDetailsFlyout = exports.DashboardMigrationDetailsFlyout = /*#__PURE__*/_react.default.memo(function DashboardMigrationDetailsFlyout({
  migrationDashboard,
  closeFlyout,
  size,
  isLoading = false,
  dashboardActions
}) {
  var _tabs$find, _migrationDashboard$e, _migrationDashboard$u, _migrationDashboard$u2;
  const summaryTab = (0, _react.useMemo)(() => ({
    id: 'summary',
    name: _translation.SUMMARY_TAB_LABEL,
    content: /*#__PURE__*/_react.default.createElement(_utils.TabContentPadding, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_summary.SummaryTab, {
      migrationDashboard: migrationDashboard,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }))
  }), [migrationDashboard]);
  const tabs = (0, _react.useMemo)(() => {
    return [summaryTab];
  }, [summaryTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTab = (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  const onTabClick = (0, _react.useCallback)(tab => {
    setSelectedTabId(tab.id);
  }, [setSelectedTabId]);
  const tabsContent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_utils.ScrollableFlyoutTabbedContent, {
      tabs: tabs,
      selectedTab: selectedTab,
      onTabClick: onTabClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 7
      }
    });
  }, [selectedTab, tabs, onTabClick]);
  const migrationsDashboardsFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'migrationDashboardsFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: size,
    onClose: closeFlyout,
    paddingSize: "l",
    key: "migration-dashboard-flyout",
    "aria-labelledby": migrationsDashboardsFlyoutTitleId,
    "data-test-subj": "dashboardDetailsFlyout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "detailsFlyoutTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: migrationsDashboardsFlyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, ((_migrationDashboard$e = migrationDashboard.elastic_dashboard) === null || _migrationDashboard$e === void 0 ? void 0 : _migrationDashboard$e.title) || migrationDashboard.original_dashboard.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_updated_by_label.UpdatedByLabel, {
    updatedBy: (_migrationDashboard$u = migrationDashboard.updated_by) !== null && _migrationDashboard$u !== void 0 ? _migrationDashboard$u : migrationDashboard.created_by,
    updatedAt: (_migrationDashboard$u2 = migrationDashboard.updated_at) !== null && _migrationDashboard$u2 !== void 0 ? _migrationDashboard$u2 : migrationDashboard['@timestamp'],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    })),
    loadedContent: tabsContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "detailsFlyoutCloseButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, _translation.CLOSE_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, dashboardActions))));
});