"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/filters/status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STATUS_FILTER_POPOVER_WIDTH = 250;
const StatusFilterButtonComponent = ({
  status,
  onStatusChanged,
  statusFilterOptions
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = (0, _react.useMemo)(() => {
    return statusFilterOptions.map(({
      label,
      data
    }) => ({
      label,
      data,
      checked: status === data.status ? 'on' : undefined
    }));
  }, [status, statusFilterOptions]);
  const handleOptionsChange = (0, _react.useCallback)((_options, _event, changedOption) => {
    var _changedOption$data;
    setIsPopoverOpen(false);
    if (changedOption.checked && changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.status) {
      onStatusChanged(changedOption.data.status);
    } else if (!changedOption.checked) {
      onStatusChanged();
    }
  }, [onStatusChanged]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    isSelected: isPopoverOpen,
    hasActiveFilters: status !== undefined,
    numActiveFilters: status ? 1 : 0,
    "data-test-subj": "statusFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, i18n.STATUS_BUTTON_TITLE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.STATUS_FILTER_ARIAL_LABEL,
    options: selectableOptions,
    onChange: handleOptionsChange,
    singleSelection: true,
    "data-test-subj": "statusFilterSelectableList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: STATUS_FILTER_POPOVER_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 20
    }
  }, list)));
};
const MemoizedStatusFilterButton = /*#__PURE__*/_react.default.memo(StatusFilterButtonComponent);
MemoizedStatusFilterButton.displayName = 'StatusFilterButton';
const StatusFilterButton = exports.StatusFilterButton = MemoizedStatusFilterButton;