"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REPROCESS_FAILED_SELECTED_ITEMS = exports.REPROCESS_FAILED_ITEMS = exports.REPROCESS_FAILED_ARIA_LABEL = exports.INSTALL_TRANSLATED_ITEMS_EMPTY_STATE = exports.INSTALL_TRANSLATED_ITEMS = exports.INSTALL_TRANSLATED_ARIA_LABEL = exports.INSTALL_SELECTED_ITEMS = exports.INSTALL_SELECTED_ARIA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_SELECTED_ITEMS = numberOfSelectedItems => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.installSelectedItems', {
    defaultMessage: 'Install selected ({numberOfSelectedItems})',
    values: {
      numberOfSelectedItems
    }
  });
};
exports.INSTALL_SELECTED_ITEMS = INSTALL_SELECTED_ITEMS;
const REPROCESS_FAILED_ITEMS = numberOfFailedItems => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.reprocessFailedItems', {
    defaultMessage: 'Reprocess failed ({numberOfFailedItems})',
    values: {
      numberOfFailedItems
    }
  });
};
exports.REPROCESS_FAILED_ITEMS = REPROCESS_FAILED_ITEMS;
const REPROCESS_FAILED_SELECTED_ITEMS = numberOfSelectedItems => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.reprocessFailedSelectedItems', {
    defaultMessage: 'Reprocess selected failed ({numberOfSelectedItems})',
    values: {
      numberOfSelectedItems
    }
  });
};
exports.REPROCESS_FAILED_SELECTED_ITEMS = REPROCESS_FAILED_SELECTED_ITEMS;
const INSTALL_SELECTED_ARIA_LABEL = exports.INSTALL_SELECTED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.installSelectedButtonAriaLabel', {
  defaultMessage: 'Install selected translated items'
});
const INSTALL_TRANSLATED_ARIA_LABEL = exports.INSTALL_TRANSLATED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.installTranslatedButtonAriaLabel', {
  defaultMessage: 'Install all translated items'
});
const INSTALL_TRANSLATED_ITEMS = numberOfAllItems => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.installTranslatedItems', {
    defaultMessage: 'Install translated ({numberOfAllItems})',
    values: {
      numberOfAllItems
    }
  });
};
exports.INSTALL_TRANSLATED_ITEMS = INSTALL_TRANSLATED_ITEMS;
const INSTALL_TRANSLATED_ITEMS_EMPTY_STATE = exports.INSTALL_TRANSLATED_ITEMS_EMPTY_STATE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.installTranslatedItemsEmptyState', {
  defaultMessage: 'Install translated'
});
const REPROCESS_FAILED_ARIA_LABEL = exports.REPROCESS_FAILED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.common.table.reprocessFailedItemsButtonAriaLabel', {
  defaultMessage: 'Reprocess failed'
});