"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertCountQuery = void 0;
var _react = require("react");
var _dataService = require("@kbn/data-service");
var _esQuery = require("@kbn/es-query");
var _kibana = require("../../common/lib/kibana");
var _use_query = require("../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../detections/containers/detection_engine/alerts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAlertCountQuery = ({
  from,
  skip = false,
  signalIndexName,
  query,
  filters,
  to
}) => {
  var _data$hits$total$valu;
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const additionalFilters = (0, _react.useMemo)(() => {
    try {
      var _filters$filter;
      const config = (0, _dataService.getEsQueryConfig)(uiSettings);
      return [(0, _esQuery.buildEsQuery)(undefined, query != null ? [query] : [], (_filters$filter = filters === null || filters === void 0 ? void 0 : filters.filter(f => f.meta.disabled === false)) !== null && _filters$filter !== void 0 ? _filters$filter : [], config)];
    } catch (e) {
      return [];
    }
  }, [query, filters, uiSettings]);
  const currentQuery = (0, _react.useMemo)(() => ({
    size: 0,
    track_total_hits: true,
    query: {
      bool: {
        filter: [...additionalFilters, {
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }]
      }
    }
  }), [additionalFilters, from, to]);
  const {
    data,
    loading: isLoading,
    setQuery
  } = (0, _use_query.useQueryAlerts)({
    query: currentQuery,
    indexName: signalIndexName,
    skip,
    queryName: _constants.ALERTS_QUERY_NAMES.COUNT
  });
  (0, _react.useEffect)(() => {
    setQuery(currentQuery);
  }, [setQuery, currentQuery]);
  return {
    alertCount: (_data$hits$total$valu = data === null || data === void 0 ? void 0 : data.hits.total.value) !== null && _data$hits$total$valu !== void 0 ? _data$hits$total$valu : 0,
    isLoading
  };
};
exports.useAlertCountQuery = useAlertCountQuery;