"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCloudTopicId = void 0;
var _react = require("react");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const URL = '/internal/cloud/solution';
const useCloudTopicId = ({
  onComplete
}) => {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const start = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const data = await http.get(URL, {
        version: '1'
      });
      if (isSiemMigrationsCloudOnboarding(data)) {
        onComplete(_constants.OnboardingTopicId.siemMigrations);
      } else {
        onComplete(null);
      }
    } catch (_) {
      // ignore the error, we will just show the default topic
      onComplete(null);
    }
    setIsLoading(false);
  }, [onComplete, http]);
  return {
    start,
    isLoading
  };
};
exports.useCloudTopicId = useCloudTopicId;
const isSiemMigrationsCloudOnboarding = data => {
  var _data$onboardingData, _security$migration, _security$migration2;
  const {
    security
  } = (_data$onboardingData = data.onboardingData) !== null && _data$onboardingData !== void 0 ? _data$onboardingData : {};
  return (security === null || security === void 0 ? void 0 : security.useCase) === 'siem' && (security === null || security === void 0 ? void 0 : (_security$migration = security.migration) === null || _security$migration === void 0 ? void 0 : _security$migration.value) && (security === null || security === void 0 ? void 0 : (_security$migration2 = security.migration) === null || _security$migration2 === void 0 ? void 0 : _security$migration2.type) === 'splunk';
};