"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsPolicySettingsBarVisible = void 0;
exports.usePolicyDetailsArtifactsNavigateCallback = usePolicyDetailsArtifactsNavigateCallback;
exports.usePolicyDetailsSelector = usePolicyDetailsSelector;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _constants = require("../../../common/constants");
var _routing = require("../../../common/routing");
var _selectors = require("../store/policy_details/selectors");
var _constants2 = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Narrows global state down to the PolicyDetailsState before calling the provided Policy Details Selector
 * @param selector
 */
function usePolicyDetailsSelector(selector) {
  return (0, _reactRedux.useSelector)(state => selector(state[_constants.MANAGEMENT_STORE_GLOBAL_NAMESPACE][_constants.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE]));
}
function usePolicyDetailsArtifactsNavigateCallback(listId) {
  const location = usePolicyDetailsSelector(_selectors.getCurrentArtifactsLocation);
  const history = (0, _reactRouterDom.useHistory)();
  const policyId = usePolicyDetailsSelector(_selectors.policyIdFromParams);
  const {
    state
  } = (0, _reactRouterDom.useLocation)();
  const getPath = (0, _react.useCallback)(args => {
    if (listId === _securitysolutionListConstants.ENDPOINT_TRUSTED_APPS_LIST_ID) {
      return (0, _routing.getPolicyDetailsArtifactsListPath)(policyId, {
        ...location,
        ...args
      });
    } else if (listId === _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedDevices.id) {
      return (0, _routing.getPolicyTrustedDevicesPath)(policyId, {
        ...location,
        ...args
      });
    } else if (listId === _securitysolutionListConstants.ENDPOINT_EVENT_FILTERS_LIST_ID) {
      return (0, _routing.getPolicyEventFiltersPath)(policyId, {
        ...location,
        ...args
      });
    } else if (listId === _securitysolutionListConstants.ENDPOINT_BLOCKLISTS_LIST_ID) {
      return (0, _routing.getPolicyBlocklistsPath)(policyId, {
        ...location,
        ...args
      });
    } else {
      return (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId, {
        ...location,
        ...args
      });
    }
  }, [listId, location, policyId]);
  return (0, _react.useCallback)(args => history.push(getPath(args), state), [getPath, history, state]);
}
const useIsPolicySettingsBarVisible = () => {
  return window.location.pathname.includes(_constants2.POLICIES_PATH) && window.location.pathname.includes('/settings');
};
exports.useIsPolicySettingsBarVisible = useIsPolicySettingsBarVisible;