"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyEditExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _endpoint_policy_artifact_cards = require("./components/endpoint_policy_artifact_cards");
var _policy_settings_form = require("../../policy_settings_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_policy_edit_extension/endpoint_policy_edit_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Exports Endpoint-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const EndpointPolicyEditExtension = exports.EndpointPolicyEditExtension = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  newPolicy: _newPolicy
}) => {
  const policyUpdates = _newPolicy;
  const endpointPolicySettings = policyUpdates.inputs[0].config.policy.value;
  const {
    canAccessFleet
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const endpointPolicySettingsOnChangeHandler = (0, _react.useCallback)(({
    isValid,
    updatedPolicy
  }) => {
    const newPolicyInputs = (0, _lodash.cloneDeep)(policyUpdates.inputs);
    newPolicyInputs[0].config.policy.value = updatedPolicy;
    onChange({
      isValid,
      updatedPolicy: {
        inputs: newPolicyInputs
      }
    });
  }, [onChange, policyUpdates.inputs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "endpointIntegrationPolicyForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_endpoint_policy_artifact_cards.EndpointPolicyArtifactCards, {
    policyId: policy.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.settings.title",
    defaultMessage: "Policy settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_policy_settings_form.PolicySettingsForm, {
    policy: endpointPolicySettings,
    onChange: endpointPolicySettingsOnChangeHandler,
    mode: canAccessFleet ? 'edit' : 'view',
    "data-test-subj": "endpointPolicyForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }))));
});
EndpointPolicyEditExtension.displayName = 'EndpointPolicyEditExtension';