"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyCreateExtension = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _help_text_with_padding = require("./components/help_text_with_padding");
var _endpoint_event_collection_preset = require("./components/endpoint_event_collection_preset");
var _use_license = require("../../../../../../common/hooks/use_license");
var _translations = require("./translations");
var _use_get_protections_unavailable_component = require("../../policy_settings_form/hooks/use_get_protections_unavailable_component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_policy_create_extension/endpoint_policy_create_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PREFIX = 'endpoint_policy_create_extension';
const environmentMapping = {
  cloud: _translations.CLOUD_SECURITY,
  endpoint: _translations.ENDPOINT
};
const cloudEventMapping = {
  INTERACTIVE_ONLY: _translations.INTERACTIVE_ONLY,
  ALL_EVENTS: _translations.ALL_EVENTS
};
const environmentOptions = [{
  value: 'endpoint',
  text: _translations.ENDPOINT
}, {
  value: 'cloud',
  text: _translations.CLOUD_SECURITY
}];

/**
 * Exports Endpoint-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const EndpointPolicyCreateExtension = exports.EndpointPolicyCreateExtension = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const showEndpointEventCollectionOnlyPreset = Boolean((0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)());
  const [endpointPreset, setEndpointPreset] = (0, _react.useState)('EDRComplete');
  const [selectedCloudEvent, setSelectedCloudEvent] = (0, _react.useState)('INTERACTIVE_ONLY');
  const [selectedEnvironment, setSelectedEnvironment] = (0, _react.useState)('endpoint');

  // Show NGAV license note when Gold and below
  // Show EDR licenses note when Platinum and Below
  const showNote = endpointPreset === 'NGAV' && !isPlatinumPlus || ['EDREssential', 'EDRComplete'].includes(endpointPreset) && !isEnterprise;

  // Fleet will initialize the create form with a default name for the integrating policy, however,
  // for endpoint security, we want the user to explicitly type in a name, so we blank it out
  // only during 1st component render (thus why the eslint disabled rule below).
  // Default values for config are endpoint + NGAV
  (0, _react.useEffect)(() => {
    // When ONLY Data collection is allowed, the updates to the policy are handled by the
    // EndpointEventCollectionPreset component
    if (!showEndpointEventCollectionOnlyPreset || showEndpointEventCollectionOnlyPreset && selectedEnvironment === 'cloud') {
      if (newPolicy.inputs.length === 0) {
        onChange({
          isValid: false,
          updatedPolicy: {
            ...newPolicy,
            name: '',
            inputs: [{
              enabled: true,
              streams: [],
              type: _constants.ENDPOINT_INTEGRATION_CONFIG_KEY,
              config: {
                _config: {
                  value: {
                    type: 'endpoint',
                    endpointConfig: {
                      preset: 'NGAV'
                    }
                  }
                }
              }
            }]
          }
        });
      } else {
        onChange({
          isValid: true,
          updatedPolicy: {
            ...newPolicy,
            inputs: [{
              ...newPolicy.inputs[0],
              config: {
                _config: {
                  value: {
                    type: selectedEnvironment,
                    ...(selectedEnvironment === 'cloud' ? {
                      eventFilters: {
                        nonInteractiveSession: selectedCloudEvent === 'INTERACTIVE_ONLY'
                      }
                    } : {
                      endpointConfig: {
                        preset: endpointPreset
                      }
                    })
                  }
                }
              }
            }]
          }
        });
      }
    }
  }, [selectedEnvironment, selectedCloudEvent, endpointPreset, onChange, newPolicy, showEndpointEventCollectionOnlyPreset]);
  const onChangeEnvironment = (0, _react.useCallback)(e => {
    var _e$target;
    setSelectedEnvironment(e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.value);
  }, []);
  const onChangeCloudEvent = (0, _react.useCallback)(e => {
    setSelectedCloudEvent(e.target.value);
  }, []);
  const onChangeEndpointPreset = (0, _react.useCallback)(e => {
    setEndpointPreset(e.target.value);
  }, []);
  const getEndpointPresetsProps = (0, _react.useCallback)(preset => ({
    id: `${PREFIX}_endpoint_preset_${preset}`,
    label: _constants.endpointPresetsMapping[preset].label,
    value: preset,
    checked: endpointPreset === preset,
    onChange: onChangeEndpointPreset
  }), [endpointPreset, onChangeEndpointPreset]);
  const getCloudEventsProps = (0, _react.useCallback)(cloudEvent => ({
    id: `${PREFIX}_cloud_event_${cloudEvent}`,
    label: cloudEventMapping[cloudEvent],
    value: cloudEvent,
    checked: selectedCloudEvent === cloudEvent,
    onChange: onChangeCloudEvent
  }), [selectedCloudEvent, onChangeCloudEvent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.enablePrevention",
    defaultMessage: "Select configuration settings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.quickSettingsTranslation",
    defaultMessage: "Use quick settings to configure the integration to {environments}. You can make configuration changes after you create the integration.",
    values: {
      environments: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.ingestManager.createPackagePolicy.environments",
        defaultMessage: "protect your traditional endpoints or dynamic cloud environments",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.selectEnvironmentTextTranslation",
      defaultMessage: "Select the type of environment you want to protect:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 219,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "selectIntegrationTypeId",
    "data-test-subj": "selectIntegrationTypeId",
    options: environmentOptions,
    value: selectedEnvironment,
    onChange: onChangeEnvironment,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  })), selectedEnvironment === 'endpoint' ? !showEndpointEventCollectionOnlyPreset ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 241,
        columnNumber: 27
      }
    }, _translations.DATA_COLLECTION_HELP_TEXT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getEndpointPresetsProps('DataCollection'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointNGAV",
      defaultMessage: "Machine learning malware, ransomware, memory threat, malicious behavior, and credential theft preventions, plus process telemetry",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getEndpointPresetsProps('NGAV'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointEDREssential",
      defaultMessage: "Everything in NGAV, plus file and network telemetry",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getEndpointPresetsProps('EDREssential'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointEDRComplete",
      defaultMessage: "Everything in Essential EDR, plus full telemetry",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getEndpointPresetsProps('EDRComplete'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 17
    }
  }))), showNote && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "create-ensdpoint-policy-license-note",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 23
    }
  }, _constants.endpointPresetsMapping[endpointPreset].note, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.seeDocumentation",
    defaultMessage: "See {documentation} for more information.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.ingestManager.createPackagePolicy.seeDocumentationLink",
        defaultMessage: "documentation",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 33
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 25
    }
  })))))) : /*#__PURE__*/_react.default.createElement(_endpoint_event_collection_preset.EndpointEventCollectionPreset, {
    onChange: onChange,
    newPolicy: newPolicy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.interactiveSessionSuggestionTranslation",
    defaultMessage: "To reduce data ingestion volume, select Interactive only",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeAllEventsInfo",
      defaultMessage: "Monitors and collects data from all system executions, including those launched by daemon processes, such as {nginx}, {postgres} and {cron}. {recommendation}",
      values: {
        nginx: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 341,
            columnNumber: 30
          }
        }, 'nginx'),
        postgres: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 342,
            columnNumber: 33
          }
        }, 'postgres'),
        cron: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 343,
            columnNumber: 29
          }
        }, 'cron'),
        recommendation: /*#__PURE__*/_react.default.createElement("em", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 345,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 346,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeAllEventsInfoRecommendation",
          defaultMessage: "Recommended for Cloud Workload Protection, auditing and forensics use cases.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 347,
            columnNumber: 29
          }
        })))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getCloudEventsProps('ALL_EVENTS'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 365,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeInteractiveOnlyInfo",
      defaultMessage: "Captures live system interactions initiated by users through programs like {ssh} or {telnet}. {recommendation}",
      values: {
        ssh: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 370,
            columnNumber: 28
          }
        }, 'ssh'),
        telnet: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 371,
            columnNumber: 31
          }
        }, 'telnet'),
        recommendation: /*#__PURE__*/_react.default.createElement("em", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 373,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react.default.createElement("strong", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 374,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeInteractiveOnlyInfoRecommendation",
          defaultMessage: "Recommended for auditing and forensic use cases.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 375,
            columnNumber: 29
          }
        })))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, (0, _extends2.default)({}, getCloudEventsProps('INTERACTIVE_ONLY'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 387,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 9
    }
  }));
}, (prevProps, nextProps) => {
  return prevProps.newPolicy.name === nextProps.newPolicy.name;
});
EndpointPolicyCreateExtension.displayName = 'EndpointPolicyCreateExtension';