"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/components/exception_items_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUMMARY_KEYS = ['windows', 'macos', 'linux', 'total'];
const SUMMARY_LABELS = {
  windows: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.windows', {
    defaultMessage: 'Windows'
  }),
  linux: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.linux', {
    defaultMessage: 'Linux'
  }),
  macos: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.macos', {
    defaultMessage: 'Mac'
  }),
  total: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.total', {
    defaultMessage: 'Total'
  })
};
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  font-size: ${({
  isSmall,
  theme
}) => isSmall ? theme.eui.euiFontSizeXS : 'inherit'};
  font-weight: ${({
  isSmall
}) => isSmall ? '1px' : 'inherit'};
`;
const CSS_BOLD = {
  fontWeight: 'bold'
};
const ExceptionItemsSummary = exports.ExceptionItemsSummary = /*#__PURE__*/(0, _react.memo)(({
  stats,
  isSmall = false
}) => {
  const getItem = (0, _react.useCallback)(stat => {
    var _stats$stat;
    if (stat !== 'total' && isSmall) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: stat,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(SummaryStat, {
      value: (_stats$stat = stats === null || stats === void 0 ? void 0 : stats[stat]) !== null && _stats$stat !== void 0 ? _stats$stat : 0,
      color: stat === 'total' && !isSmall ? 'primary' : 'default',
      key: stat,
      isSmall: isSmall,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 13
      }
    }, SUMMARY_LABELS[stat]));
  }, [stats, isSmall]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: isSmall ? 'flexStart' : 'spaceAround',
    gutterSize: isSmall ? 's' : 'l',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, SUMMARY_KEYS.map(stat => getItem(stat)));
});
ExceptionItemsSummary.displayName = 'ExceptionItemsSummary';
const SummaryStat = /*#__PURE__*/(0, _react.memo)(({
  children,
  value,
  color,
  isSmall = false,
  ...commonProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-displayInlineBlock",
    size: isSmall ? 'xs' : 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    justifyContent: isSmall ? 'flexStart' : 'center',
    direction: isSmall ? 'rowReverse' : 'row',
    alignItems: "center",
    gutterSize: isSmall ? 'xs' : 'l',
    isSmall: isSmall,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, !isSmall ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: color === 'primary' ? CSS_BOLD : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, children) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, value))));
});
SummaryStat.displayName = 'SummaryState';