"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NAME_PLACEHOLDER = exports.NAME_LABEL = exports.NAME_ERROR = exports.IP_PLACEHOLDER = exports.IP_LABEL = exports.IP_ERROR = exports.DESCRIPTION_PLACEHOLDER = exports.DESCRIPTION_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME_PLACEHOLDER = exports.NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.placeholder', {
  defaultMessage: 'Host isolation exception name'
});
const NAME_LABEL = exports.NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.label', {
  defaultMessage: 'Name your host isolation exceptions'
});
const NAME_ERROR = exports.NAME_ERROR = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.error', {
  defaultMessage: "The name can't be empty"
});
const DESCRIPTION_PLACEHOLDER = exports.DESCRIPTION_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.description.placeholder', {
  defaultMessage: 'Describe your host isolation exception'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.description.label', {
  defaultMessage: 'Description'
});
const IP_PLACEHOLDER = exports.IP_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.placeholder', {
  defaultMessage: 'Ex 0.0.0.0/24'
});
const IP_LABEL = exports.IP_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.label', {
  defaultMessage: 'Enter IP Address'
});
const IP_ERROR = exports.IP_ERROR = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.error', {
  defaultMessage: 'The IP is invalid. Only IPv4 with optional CIDR is supported'
});