"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockListForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _securitysolutionListUtils = require("@kbn/securitysolution-list-utils");
var _lodash = require("lodash");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _use_can_assign_artifact_per_policy = require("../../../../hooks/artifacts/use_can_assign_artifact_per_policy");
var _formatted_error = require("../../../../components/formatted_error");
var _translations = require("../../../../common/translations");
var _translations2 = require("../../translations");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _validations = require("../../../../../../common/endpoint/service/artifacts/validations");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/blocklist/view/components/blocklist_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const testIdPrefix = 'blocklist-form';
function createValidationMessage(message) {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 10
    }
  }, message);
}
function getDropdownDisplay(field) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations2.CONDITION_FIELD_TITLE[field], /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, _translations2.CONDITION_FIELD_DESCRIPTION[field]));
}
function isValid(itemValidation) {
  return !Object.values(itemValidation).some(errors => Object.keys(errors).length);
}

// eslint-disable-next-line react/display-name
const BlockListForm = exports.BlockListForm = /*#__PURE__*/(0, _react.memo)(({
  item,
  onChange,
  mode,
  error: submitError
}) => {
  const [nameVisited, setNameVisited] = (0, _react.useState)(false);
  const [valueVisited, setValueVisited] = (0, _react.useState)({
    value: false
  }); // Use object to trigger re-render
  const warningsRef = (0, _react.useRef)({
    name: {},
    value: {}
  });
  const errorsRef = (0, _react.useRef)({
    name: {},
    value: {}
  });
  const [hasFormChanged, setHasFormChanged] = (0, _react.useState)(false);
  const showAssignmentSection = (0, _use_can_assign_artifact_per_policy.useCanAssignArtifactPerPolicy)(item, mode, hasFormChanged);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(testIdPrefix);
  const blocklistEntry = (0, _react.useMemo)(() => {
    if (!item.entries.length) {
      return {
        field: 'file.hash.*',
        operator: _securitysolutionIoTsListTypes.ListOperatorEnum.INCLUDED,
        type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
        value: []
      };
    }
    return item.entries[0];
  }, [item.entries]);
  const windowsSignatureField = 'file.Ext.code_signature';
  const isWindowsSignatureEntry = blocklistEntry.field === windowsSignatureField;
  const displaySingleValueInput = isWindowsSignatureEntry && blocklistEntry.type === _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH;
  const selectedOs = (0, _react.useMemo)(() => {
    var _item$os_types;
    if (!(item !== null && item !== void 0 && (_item$os_types = item.os_types) !== null && _item$os_types !== void 0 && _item$os_types.length)) {
      return _securitysolutionUtils.OperatingSystem.WINDOWS;
    }
    return item.os_types[0];
  }, [item === null || item === void 0 ? void 0 : item.os_types]);
  const selectedValues = (0, _react.useMemo)(() => {
    if (Array.isArray(blocklistEntry.value)) {
      return blocklistEntry.value.map(label => ({
        label,
        'data-test-subj': getTestId(`values-input-${label}`)
      }));
    } else {
      return [{
        label: blocklistEntry.value,
        'data-test-subj': getTestId(`values-input-${blocklistEntry.value}`)
      }];
    }
  }, [blocklistEntry.value, getTestId]);
  const osOptions = (0, _react.useMemo)(() => [_securitysolutionUtils.OperatingSystem.LINUX, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.WINDOWS].map(os => ({
    value: os,
    inputDisplay: _translations.OS_TITLES[os]
  })), []);
  const fieldOptions = (0, _react.useMemo)(() => {
    const selectableFields = [];
    selectableFields.push({
      value: 'file.hash.*',
      inputDisplay: _translations2.CONDITION_FIELD_TITLE['file.hash.*'],
      dropdownDisplay: getDropdownDisplay('file.hash.*'),
      'data-test-subj': getTestId('file.hash.*')
    });
    if (selectedOs === _securitysolutionUtils.OperatingSystem.LINUX) {
      selectableFields.push({
        value: 'file.path',
        inputDisplay: _translations2.CONDITION_FIELD_TITLE['file.path'],
        dropdownDisplay: getDropdownDisplay('file.path'),
        'data-test-subj': getTestId('file.path')
      });
    } else {
      selectableFields.push({
        value: 'file.path.caseless',
        inputDisplay: _translations2.CONDITION_FIELD_TITLE['file.path.caseless'],
        dropdownDisplay: getDropdownDisplay('file.path.caseless'),
        'data-test-subj': getTestId('file.path.caseless')
      });
    }
    if (selectedOs === _securitysolutionUtils.OperatingSystem.WINDOWS) {
      selectableFields.push({
        value: windowsSignatureField,
        inputDisplay: _translations2.CONDITION_FIELD_TITLE[windowsSignatureField],
        dropdownDisplay: getDropdownDisplay(windowsSignatureField),
        'data-test-subj': getTestId(windowsSignatureField)
      });
    }
    return selectableFields;
  }, [selectedOs, getTestId]);
  const operatorOptions = (0, _react.useMemo)(() => {
    return [{
      value: _securitysolutionListUtils.isOneOfOperator.type,
      inputDisplay: _securitysolutionListUtils.isOneOfOperator.message,
      dropdownDisplay: _securitysolutionListUtils.isOneOfOperator.message
    }, {
      value: _securitysolutionListUtils.isOperator.type,
      inputDisplay: _securitysolutionListUtils.isOperator.message,
      dropdownDisplay: _securitysolutionListUtils.isOperator.message
    }];
  }, []);
  const valueLabel = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 9
      }
    }, _translations2.VALUE_LABEL, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      type: "info",
      className: "eui-alignTop",
      iconProps: {
        className: 'eui-alignTop'
      },
      content: displaySingleValueInput ? _translations2.SINGLE_VALUE_LABEL_HELPER : _translations2.VALUE_LABEL_HELPER,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 11
      }
    }));
  }, [displaySingleValueInput]);
  const validateValues = (0, _react.useCallback)((nextItem, cleanState = false) => {
    var _ref, _nextItem$os_types, _nextItem$entries$;
    const os = (_ref = ((_nextItem$os_types = nextItem.os_types) !== null && _nextItem$os_types !== void 0 ? _nextItem$os_types : [])[0]) !== null && _ref !== void 0 ? _ref : _securitysolutionUtils.OperatingSystem.WINDOWS;
    const {
      field = 'file.hash.*',
      type = _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
      value = []
    } = (_nextItem$entries$ = nextItem.entries[0]) !== null && _nextItem$entries$ !== void 0 ? _nextItem$entries$ : {};

    // value can be a string when isOperator is selected
    const values = Array.isArray(value) ? value : [value].filter(Boolean);
    const newValueWarnings = cleanState ? {} : {
      ...warningsRef.current.value
    };
    const newNameErrors = cleanState ? {} : {
      ...errorsRef.current.name
    };
    const newValueErrors = cleanState ? {} : {
      ...errorsRef.current.value
    };

    // error if name empty
    if (!nextItem.name.trim()) {
      newNameErrors.NAME_REQUIRED = createValidationMessage(_translations2.ERRORS.NAME_REQUIRED);
    } else {
      delete newNameErrors.NAME_REQUIRED;
    }

    // error if no values
    if (!values.length) {
      newValueErrors.VALUE_REQUIRED = createValidationMessage(_translations2.ERRORS.VALUE_REQUIRED);
    } else {
      delete newValueErrors.VALUE_REQUIRED;
    }

    // error if invalid hash
    if (field === 'file.hash.*' && values.some(v => !(0, _validations.isValidHash)(v))) {
      newValueErrors.INVALID_HASH = createValidationMessage(_translations2.ERRORS.INVALID_HASH);
    } else {
      delete newValueErrors.INVALID_HASH;
    }
    const isInvalidPath = values.some(v => !(0, _securitysolutionUtils.isPathValid)({
      os,
      field,
      type,
      value: v
    }));
    // warn if invalid path
    if (field !== 'file.hash.*' && isInvalidPath) {
      newValueWarnings.INVALID_PATH = createValidationMessage(_translations2.ERRORS.INVALID_PATH);
    } else {
      delete newValueWarnings.INVALID_PATH;
    }
    // warn if duplicates
    if (values.length !== (0, _lodash.uniq)(values).length) {
      newValueWarnings.DUPLICATE_VALUES = createValidationMessage(_translations2.ERRORS.DUPLICATE_VALUES);
    } else {
      delete newValueWarnings.DUPLICATE_VALUES;
    }
    warningsRef.current = {
      ...warningsRef.current,
      value: newValueWarnings
    };
    errorsRef.current = {
      name: newNameErrors,
      value: newValueErrors
    };
  }, []);
  const handleOnNameBlur = (0, _react.useCallback)(() => {
    validateValues(item);
    setNameVisited(true);
  }, [item, validateValues]);
  const handleOnValueBlur = (0, _react.useCallback)(() => {
    validateValues(item);
    setValueVisited({
      value: true
    });
  }, [item, validateValues]);
  const handleOnNameChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      name: event.target.value
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item]);
  const handleOnDescriptionChange = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      description: event.target.value
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [onChange, item, validateValues]);
  const handleOnOsChange = (0, _react.useCallback)(os => {
    const nextItem = {
      ...item,
      os_types: [os],
      entries: [{
        ...blocklistEntry,
        field: os !== _securitysolutionUtils.OperatingSystem.WINDOWS && isWindowsSignatureEntry ? 'file.hash.*' : blocklistEntry.field,
        type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
        ...(typeof blocklistEntry.value === 'string' ? {
          value: blocklistEntry.value.length ? blocklistEntry.value.split(',') : []
        } : {})
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [item, blocklistEntry, isWindowsSignatureEntry, validateValues, onChange]);
  const handleOnFieldChange = (0, _react.useCallback)(field => {
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        field,
        type: _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH_ANY,
        ...(typeof blocklistEntry.value === 'string' ? {
          value: blocklistEntry.value.length ? blocklistEntry.value.split(',') : []
        } : {})
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const generateBlocklistEntryValue = (0, _react.useCallback)((value, newOperator) => {
    if (newOperator === _securitysolutionIoTsListTypes.ListOperatorTypeEnum.MATCH) {
      return {
        value: Array.isArray(value) ? value.join(',') : value
      };
    } else {
      return {
        value: (typeof value === 'string' ? value.split(',') : value).filter(Boolean)
      };
    }
  }, []);
  const handleOperatorUpdate = (0, _react.useCallback)(newOperator => {
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        type: newOperator,
        ...generateBlocklistEntryValue(blocklistEntry.value, newOperator)
      }]
    };
    onChange({
      isValid: isValid(errorsRef.current),
      // Type ListOperatorTypeEnum is not assignable to type "wildcard"
      item: nextItem
    });
  }, [item, blocklistEntry, generateBlocklistEntryValue, onChange]);
  const handleOnValueTextChange = (0, _react.useCallback)(value => {
    const nextWarnings = {
      ...warningsRef.current.value
    };
    if (blocklistEntry.value.includes(value)) {
      nextWarnings.DUPLICATE_VALUE = createValidationMessage(_translations2.ERRORS.DUPLICATE_VALUE);
    } else {
      delete nextWarnings.DUPLICATE_VALUE;
    }
    warningsRef.current = {
      ...warningsRef.current,
      value: nextWarnings
    };

    // trigger re-render without modifying item
    setValueVisited(prevState => ({
      ...prevState
    }));
  }, [blocklistEntry]);
  const handleSingleValueUpdate = (0, _react.useCallback)(event => {
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        value: event.target.value
      }]
    };
    validateValues(nextItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [item, blocklistEntry, validateValues, onChange]);

  // only triggered on remove / clear
  const handleOnValueChange = (0, _react.useCallback)(change => {
    const value = change.map(option => option.label);
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        value
      }]
    };
    validateValues(nextItem, true);
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const handleOnValueAdd = (0, _react.useCallback)(option => {
    const splitValues = option.split(',').filter(value => value.trim());
    const value = [...blocklistEntry.value, ...splitValues];
    const nextItem = {
      ...item,
      entries: [{
        ...blocklistEntry,
        value
      }]
    };
    validateValues(nextItem);
    nextItem.entries[0].value = (0, _lodash.uniq)(nextItem.entries[0].value);
    setValueVisited({
      value: true
    });
    onChange({
      isValid: isValid(errorsRef.current),
      item: nextItem
    });
    setHasFormChanged(true);
  }, [validateValues, onChange, item, blocklistEntry]);
  const handleEffectedPolicyOnChange = (0, _react.useCallback)(updatedItem => {
    validateValues(updatedItem);
    onChange({
      isValid: isValid(errorsRef.current),
      item: updatedItem
    });
    setHasFormChanged(true);
  }, [onChange, validateValues]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    error: submitError ? /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: submitError,
      "data-test-subj": getTestId('submitError'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 534,
        columnNumber: 13
      }
    }) : undefined,
    isInvalid: !!submitError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 530,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 539,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 540,
      columnNumber: 11
    }
  }, _translations2.DETAILS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 542,
      columnNumber: 9
    }
  }), mode === 'create' && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('header-description'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 544,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 545,
      columnNumber: 13
    }
  }, _translations2.DETAILS_HEADER_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 548,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.NAME_LABEL,
    isInvalid: nameVisited && !!Object.keys(errorsRef.current.name).length,
    error: Object.values(errorsRef.current.name),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 550,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: nameVisited && !!Object.keys(errorsRef.current.name).length,
    name: "name",
    value: item.name,
    onChange: handleOnNameChange,
    onBlur: handleOnNameBlur,
    required: nameVisited,
    maxLength: 256,
    "data-test-subj": getTestId('name-input'),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.DESCRIPTION_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 568,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    name: "description",
    value: item.description,
    onChange: handleOnDescriptionChange,
    "data-test-subj": getTestId('description-input'),
    fullWidth: true,
    compressed: true,
    maxLength: 256,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 569,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 581,
      columnNumber: 11
    }
  }, _translations2.CONDITIONS_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 583,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 584,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 585,
      columnNumber: 11
    }
  }, _translations2.CONDITIONS_HEADER_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 587,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.SELECT_OS_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 589,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "os",
    options: osOptions,
    valueOfSelected: selectedOs,
    onChange: handleOnOsChange,
    "data-test-subj": getTestId('os-select'),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 590,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 601,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 602,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 603,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.FIELD_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 604,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "field",
    options: fieldOptions,
    valueOfSelected: blocklistEntry.field,
    onChange: handleOnFieldChange,
    "data-test-subj": getTestId('field-select'),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 605,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 615,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations2.OPERATOR_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 616,
      columnNumber: 15
    }
  }, isWindowsSignatureEntry ? /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    name: "operator",
    options: operatorOptions,
    valueOfSelected: blocklistEntry.type,
    onChange: handleOperatorUpdate,
    "data-test-subj": getTestId('operator-select-multi'),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 618,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "operator",
    value: _securitysolutionListUtils.isOneOfOperator.message,
    "data-test-subj": getTestId('operator-select-single'),
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 627,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: valueLabel,
    isInvalid: valueVisited.value && !!Object.keys(errorsRef.current.value).length,
    helpText: Object.values(warningsRef.current.value),
    error: Object.values(errorsRef.current.value),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 639,
      columnNumber: 9
    }
  }, displaySingleValueInput ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "value",
    value: blocklistEntry.value,
    fullWidth: true,
    onChange: handleSingleValueUpdate,
    onBlur: handleOnValueBlur,
    "data-test-subj": getTestId('value-input'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 647,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedValues,
    onBlur: handleOnValueBlur,
    onSearchChange: handleOnValueTextChange,
    onChange: handleOnValueChange,
    onCreateOption: handleOnValueAdd,
    "data-test-subj": getTestId('values-input'),
    fullWidth: true,
    noSuggestions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 656,
      columnNumber: 13
    }
  })), showAssignmentSection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 671,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 672,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    item: item,
    onChange: handleEffectedPolicyOnChange,
    description: _translations2.POLICY_SELECT_DESCRIPTION,
    "data-test-subj": getTestId('effectedPolicies'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 673,
      columnNumber: 15
    }
  }))));
});