"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = exports.getManagementFilteredLinks = void 0;
var _i18n = require("@kbn/i18n");
var _check_artifact_has_data = require("./services/exceptions_list/check_artifact_has_data");
var _authz = require("../../common/endpoint/service/authz");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _use_license = require("../common/hooks/use_license");
var _links = require("../notes/links");
var _console = require("../common/icons/console");
var _shield = require("../common/icons/shield");
var _endpoints = require("../common/icons/endpoints");
var _tool = require("../common/icons/tool");
var _pipeline = require("../common/icons/pipeline");
var _saved_object = require("../common/icons/saved_object");
var _dashboards = require("../common/icons/dashboards");
var _entity_analytics = require("../common/icons/entity_analytics");
var _host_isolation_exceptions_api_client = require("./pages/host_isolation_exceptions/host_isolation_exceptions_api_client");
var _asset_criticality = require("../common/icons/asset_criticality");
var _device_control = require("../common/icons/device_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categories = [{
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.entityAnalytics', {
    defaultMessage: 'Entity analytics'
  }),
  linkIds: [_constants.SecurityPageName.entityAnalyticsManagement, _constants.SecurityPageName.entityAnalyticsEntityStoreManagement]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.endpoints', {
    defaultMessage: 'Endpoints'
  }),
  linkIds: [_constants.SecurityPageName.endpoints, _constants.SecurityPageName.policies, _constants.SecurityPageName.endpointExceptions, _constants.SecurityPageName.trustedApps, _constants.SecurityPageName.trustedDevices, _constants.SecurityPageName.eventFilters, _constants.SecurityPageName.hostIsolationExceptions, _constants.SecurityPageName.blocklist, _constants.SecurityPageName.responseActionsHistory]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.investigations', {
    defaultMessage: 'Investigations'
  }),
  linkIds: [_constants.SecurityPageName.notes]
}];
const links = exports.links = {
  id: _constants.SecurityPageName.administration,
  title: _translations.MANAGE,
  path: _constants.MANAGE_PATH,
  skipUrlState: true,
  hideTimeline: true,
  globalNavPosition: 12,
  capabilities: [`${_constants.SECURITY_FEATURE_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.manage', {
    defaultMessage: 'Manage'
  })],
  categories,
  links: [{
    id: _constants.SecurityPageName.endpoints,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.endpointsDescription', {
      defaultMessage: 'Hosts running Elastic Defend.'
    }),
    landingIcon: _endpoints.IconEndpoints,
    title: _translations.ENDPOINTS,
    path: _constants.ENDPOINTS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.policies,
    title: _translations.POLICIES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.policiesDescription', {
      defaultMessage: 'Use policies to customize endpoint and cloud workload protections and other configurations.'
    }),
    landingIcon: _tool.IconTool,
    path: _constants.POLICIES_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.endpointExceptions,
    title: _translations.ENDPOINT_EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.endpointExceptionsDescription', {
      defaultMessage: 'Add exceptions to your hosts.'
    }),
    landingIcon: _tool.IconTool,
    path: _constants.ENDPOINT_EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'endpointExceptionsMovedUnderManagement'
  }, {
    id: _constants.SecurityPageName.trustedApps,
    title: _translations.TRUSTED_APPLICATIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.trustedApplicationsDescription', {
      defaultMessage: 'Improve performance or alleviate conflicts with other applications running on your hosts.'
    }),
    landingIcon: _dashboards.IconDashboards,
    path: _constants.TRUSTED_APPS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.trustedDevices,
    title: _translations.TRUSTED_DEVICES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.trustedDevicesDescription', {
      defaultMessage: 'Specify which external devices can connect to your endpoints even when Device Control is enabled.'
    }),
    landingIcon: _device_control.IconDeviceControl,
    path: _constants.TRUSTED_DEVICES_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'trustedDevices',
    capabilities: [`${_constants.SECURITY_FEATURE_ID}.readTrustedDevices`],
    licenseType: 'enterprise'
  }, {
    id: _constants.SecurityPageName.eventFilters,
    title: _translations.EVENT_FILTERS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.eventFiltersDescription', {
      defaultMessage: 'Exclude high volume or unwanted events being written into Elasticsearch.'
    }),
    landingIcon: _pipeline.IconPipeline,
    path: _constants.EVENT_FILTERS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.hostIsolationExceptions,
    title: _translations.HOST_ISOLATION_EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.hostIsolationDescription', {
      defaultMessage: 'Allow isolated hosts to communicate with specific IPs.'
    }),
    landingIcon: _saved_object.IconSavedObject,
    path: _constants.HOST_ISOLATION_EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.blocklist,
    title: _translations.BLOCKLIST,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.blocklistDescription', {
      defaultMessage: 'Exclude unwanted applications from running on your hosts.'
    }),
    landingIcon: _shield.IconShield,
    path: _constants.BLOCKLIST_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.entityAnalyticsManagement,
    title: _translations.ENTITY_ANALYTICS_RISK_SCORE,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityRiskScoringDescription', {
      defaultMessage: "Monitor entities' risk scores, and track anomalies."
    }),
    landingIcon: _entity_analytics.IconEntityAnalytics,
    path: _constants.ENTITY_ANALYTICS_MANAGEMENT_PATH,
    skipUrlState: true,
    hideTimeline: true,
    capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`],
    experimentalKey: 'riskScoringRoutesEnabled',
    licenseType: 'platinum'
  }, {
    id: _constants.SecurityPageName.entityAnalyticsEntityStoreManagement,
    title: _translations.ENTITY_STORE,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.entityStoreDescription', {
      defaultMessage: 'Store data for entities observed in events.'
    }),
    landingIcon: _asset_criticality.IconAssetCriticality,
    path: _constants.ENTITY_ANALYTICS_ENTITY_STORE_MANAGEMENT_PATH,
    skipUrlState: true,
    hideTimeline: true,
    capabilities: [`${_constants.SECURITY_FEATURE_ID}.entity-analytics`]
  }, {
    id: _constants.SecurityPageName.responseActionsHistory,
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.actionHistoryDescription', {
      defaultMessage: 'View the history of response actions performed on hosts.'
    }),
    landingIcon: _console.IconConsole,
    path: _constants.RESPONSE_ACTIONS_HISTORY_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, _links.links]
};
const excludeLinks = linkIds => {
  var _links$links;
  return {
    ...links,
    links: (_links$links = links.links) === null || _links$links === void 0 ? void 0 : _links$links.filter(link => !linkIds.includes(link.id))
  };
};
const getManagementFilteredLinks = async (core, plugins) => {
  var _plugins$fleet;
  const fleetAuthz = (_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.authz;
  const currentUser = await plugins.security.authc.getCurrentUser();
  const {
    canReadActionsLogManagement,
    canAccessHostIsolationExceptions,
    canReadHostIsolationExceptions,
    canReadEndpointList,
    canReadEndpointExceptions,
    canReadTrustedApplications,
    canReadTrustedDevices,
    canReadEventFilters,
    canReadBlocklist,
    canReadPolicyManagement
  } = fleetAuthz && currentUser ? (0, _authz.calculateEndpointAuthz)(_use_license.licenseService, fleetAuthz, currentUser.roles) : (0, _authz.getEndpointAuthzInitialState)();
  const showHostIsolationExceptions = canAccessHostIsolationExceptions ||
  // access host isolation exceptions is a paid feature, always show the link.
  // read host isolation exceptions is not a paid feature, to allow deleting exceptions after a downgrade scenario.
  // however, in this situation we allow to access only when there is data, otherwise the link won't be accessible.
  canReadHostIsolationExceptions && (await (0, _check_artifact_has_data.checkArtifactHasData)(_host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(core.http)));
  const linksToExclude = [];
  if (!canReadEndpointList) {
    linksToExclude.push(_constants.SecurityPageName.endpoints);
  }
  if (!canReadPolicyManagement) {
    linksToExclude.push(_constants.SecurityPageName.policies);
  }
  if (!canReadEndpointExceptions) {
    linksToExclude.push(_constants.SecurityPageName.endpointExceptions);
  }
  if (!canReadActionsLogManagement) {
    linksToExclude.push(_constants.SecurityPageName.responseActionsHistory);
  }
  if (!showHostIsolationExceptions) {
    linksToExclude.push(_constants.SecurityPageName.hostIsolationExceptions);
  }
  if (!canReadTrustedApplications) {
    linksToExclude.push(_constants.SecurityPageName.trustedApps);
  }
  if (!canReadTrustedDevices) {
    linksToExclude.push(_constants.SecurityPageName.trustedDevices);
  }
  if (!canReadEventFilters) {
    linksToExclude.push(_constants.SecurityPageName.eventFilters);
  }
  if (!canReadBlocklist) {
    linksToExclude.push(_constants.SecurityPageName.blocklist);
  }
  return excludeLinks(linksToExclude);
};
exports.getManagementFilteredLinks = getManagementFilteredLinks;