"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkFetchFleetIntegrationPolicies = void 0;
var _reactQuery = require("@kbn/react-query");
var _common = require("@kbn/fleet-plugin/common");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve multiple integration policies (aka: package policies) from fleet using their IDs
 * @param ids
 * @param ignoreMissing
 * @param options
 */
const useBulkFetchFleetIntegrationPolicies = ({
  ids,
  ignoreMissing = true
}, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['bulkFetchFleetIntegrationPolicies', ids, ignoreMissing],
    refetchOnWindowFocus: false,
    ...options,
    queryFn: async () => {
      return http.post(_common.packagePolicyRouteService.getBulkGetPath(), {
        body: JSON.stringify({
          ids,
          ignoreMissing
        }),
        version: '2023-10-31'
      });
    }
  });
};
exports.useBulkFetchFleetIntegrationPolicies = useBulkFetchFleetIntegrationPolicies;