"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _kibana = require("../../../common/lib/kibana");
var _test_ids = require("./test_ids");
var _telemetry = require("../../../common/lib/telemetry");
var _link_utils = require("../utils/link_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/preview_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a link that opens a preview panel
 * If the field is not previewable, the link will not be rendered
 */
const PreviewLink = ({
  field,
  value,
  scopeId,
  ruleId,
  children,
  ancestorsIndexName,
  'data-test-subj': dataTestSubj = _test_ids.FLYOUT_PREVIEW_LINK_TEST_ID
}) => {
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const previewParams = (0, _react.useMemo)(() => (0, _link_utils.getPreviewPanelParams)({
    value,
    field,
    scopeId,
    ruleId,
    ancestorsIndexName
  }), [value, field, scopeId, ruleId, ancestorsIndexName]);
  const onClick = (0, _react.useCallback)(() => {
    if (previewParams) {
      openPreviewPanel({
        id: previewParams.id,
        params: previewParams.params
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: scopeId,
        panel: 'preview'
      });
    }
  }, [scopeId, telemetry, openPreviewPanel, previewParams]);
  return previewParams ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, children !== null && children !== void 0 ? children : value) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children !== null && children !== void 0 ? children : value);
};
exports.PreviewLink = PreviewLink;