"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineFlyout = exports.TIMELINE_ON_CLOSE_EVENT = exports.SecuritySolutionFlyout = exports.SECURITY_SOLUTION_ON_CLOSE_EVENT = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _cloudSecurityPostureGraph = require("@kbn/cloud-security-posture-graph");
var _generic_details_left = require("./entity_details/generic_details_left");
var _generic_right = require("./entity_details/generic_right");
var _context = require("./ai_for_soc/context");
var _ai_for_soc = require("./ai_for_soc");
var _context2 = require("./document_details/session_view/context");
var _session_view = require("./document_details/session_view");
var _network_details = require("./network_details");
var _flyouts = require("./document_details/shared/constants/flyouts");
var _panel_keys = require("./document_details/shared/constants/panel_keys");
var _isolate_host = require("./document_details/isolate_host");
var _context3 = require("./document_details/isolate_host/context");
var _context4 = require("./document_details/shared/context");
var _right = require("./document_details/right");
var _left = require("./document_details/left");
var _preview = require("./document_details/preview");
var _alert_reason = require("./document_details/alert_reason");
var _context5 = require("./document_details/alert_reason/context");
var _right2 = require("./rule_details/right");
var _user_right = require("./entity_details/user_right");
var _user_details_left = require("./entity_details/user_details_left");
var _host_right = require("./entity_details/host_right");
var _host_details_left = require("./entity_details/host_details_left");
var _analyzer_panels = require("./document_details/analyzer_panels");
var _constants = require("./entity_details/shared/constants");
var _service_right = require("./entity_details/service_right");
var _service_details_left = require("./entity_details/service_details_left");
var _constants2 = require("./csp_details/findings_flyout/constants");
var _findings_right = require("./csp_details/findings_flyout/findings_right");
var _panel_keys2 = require("./ai_for_soc/constants/panel_keys");
var _constants3 = require("./csp_details/vulnerabilities_flyout/constants");
var _vulnerabilities_right = require("./csp_details/vulnerabilities_flyout/vulnerabilities_right");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GraphGroupedNodePreviewPanel = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/cloud-security-posture-graph'))).then(module => ({
  default: module.GraphGroupedNodePreviewPanel
})));

/**
 * List of all panels that will be used within the document details expandable flyout.
 * This needs to be passed to the expandable flyout registeredPanels property.
 */
const expandableFlyoutDocumentsPanels = [{
  key: _panel_keys.DocumentDetailsRightPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_right.RightPanel, {
    path: props.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsLeftPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_left.LeftPanel, {
    path: props.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context4.DocumentDetailsProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_preview.PreviewPanel, {
    path: props.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsAlertReasonPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context5.AlertReasonPanelProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_reason.AlertReasonPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }))
}, {
  key: _cloudSecurityPostureGraph.GraphGroupedNodePreviewPanelKey,
  component: props => {
    // TODO Fix typing issue here
    const params = props.params;
    return /*#__PURE__*/_react.default.createElement(GraphGroupedNodePreviewPanel, (0, _extends2.default)({}, params, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 14
      }
    }));
  }
}, {
  key: _right2.RulePanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_right2.RulePanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 27
    }
  }))
}, {
  key: _right2.RulePreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_right2.RulePanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsIsolateHostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context3.IsolateHostPanelProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_isolate_host.IsolateHostPanel, {
    path: props.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsAnalyzerPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_analyzer_panels.AnalyzerPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }))
}, {
  key: _panel_keys.DocumentDetailsSessionViewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context2.SessionViewPanelProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_session_view.SessionViewPanel, {
    path: props.path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }))
}, {
  key: _constants.UserPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 27
    }
  }))
}, {
  key: _user_details_left.UserDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_details_left.UserDetailsPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }))
}, {
  key: _user_right.UserPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_user_right.UserPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }))
}, {
  key: _constants.HostPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_right.HostPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 27
    }
  }))
}, {
  key: _host_details_left.HostDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_details_left.HostDetailsPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }))
}, {
  key: _host_right.HostPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_host_right.HostPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }))
}, {
  key: _network_details.NetworkPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_network_details.NetworkPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 27
    }
  }))
}, {
  key: _network_details.NetworkPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_network_details.NetworkPanel, (0, _extends2.default)({}, props.params, {
    isPreviewMode: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }))
}, {
  key: _constants.ServicePanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_service_right.ServicePanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 27
    }
  }))
}, {
  key: _service_details_left.ServiceDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_service_details_left.ServiceDetailsPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 7
    }
  }))
}, {
  key: _constants.GenericEntityPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_generic_right.GenericEntityPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }))
}, {
  key: _generic_details_left.GenericEntityDetailsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_generic_details_left.GenericEntityDetailsPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 7
    }
  }))
}, {
  key: _constants2.MisconfigurationFindingsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_findings_right.FindingsMisconfigurationPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 7
    }
  }))
}, {
  key: _panel_keys2.IOCPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_context.AIForSOCDetailsProvider, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ai_for_soc.AIForSOCPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 9
    }
  }))
}, {
  key: _constants2.MisconfigurationFindingsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_findings_right.FindingsMisconfigurationPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }))
}, {
  key: _constants3.VulnerabilityFindingsPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_vulnerabilities_right.FindingsVulnerabilityPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 7
    }
  }))
}, {
  key: _constants3.VulnerabilityFindingsPreviewPanelKey,
  component: props => /*#__PURE__*/_react.default.createElement(_vulnerabilities_right.FindingsVulnerabilityPanel, (0, _extends2.default)({}, props.params, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }))
}];
const SECURITY_SOLUTION_ON_CLOSE_EVENT = exports.SECURITY_SOLUTION_ON_CLOSE_EVENT = `expandable-flyout-on-close-${_flyouts.Flyouts.securitySolution}`;
const TIMELINE_ON_CLOSE_EVENT = exports.TIMELINE_ON_CLOSE_EVENT = `expandable-flyout-on-close-${_flyouts.Flyouts.timeline}`;

/**
 * Flyout used for the Security Solution application
 * We keep the default EUI 1001 z-index to ensure it is always rendered behind Timeline (which has a z-index of 1002)
 * We propagate the onClose callback to the rest of Security Solution using a window event 'expandable-flyout-on-close-SecuritySolution'
 * This flyout support push/overlay mode. The value is saved in local storage.
 */
const SecuritySolutionFlyout = exports.SecuritySolutionFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onClose = (0, _react.useCallback)(() => window.dispatchEvent(new CustomEvent(SECURITY_SOLUTION_ON_CLOSE_EVENT, {
    detail: _flyouts.Flyouts.securitySolution
  })), []);
  return /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
    registeredPanels: expandableFlyoutDocumentsPanels,
    paddingSize: "none",
    customStyles: {
      'z-index': euiTheme.levels.flyout + 1
    },
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 5
    }
  });
});
SecuritySolutionFlyout.displayName = 'SecuritySolutionFlyout';

/**
 * Flyout used in Timeline
 * We set the z-index to 1003 to ensure it is always rendered above Timeline (which has a z-index of 1002)
 * We propagate the onClose callback to the rest of Security Solution using a window event 'expandable-flyout-on-close-Timeline'
 * This flyout does not support push mode, because timeline being rendered in a modal (EUiPortal), it's very difficult to dynamically change its width.
 */
const TimelineFlyout = exports.TimelineFlyout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onClose = (0, _react.useCallback)(() => window.dispatchEvent(new CustomEvent(TIMELINE_ON_CLOSE_EVENT, {
    detail: _flyouts.Flyouts.timeline
  })), []);
  return /*#__PURE__*/_react.default.createElement(_expandableFlyout.ExpandableFlyout, {
    registeredPanels: expandableFlyoutDocumentsPanels,
    paddingSize: "none",
    customStyles: {
      'z-index': euiTheme.levels.flyout + 3
    },
    onClose: onClose,
    flyoutCustomProps: {
      pushVsOverlay: {
        disabled: true,
        tooltip: 'Push mode is not supported in Timeline'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 5
    }
  });
});
TimelineFlyout.displayName = 'TimelineFlyout';