"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePinnedFields = exports.FieldsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _ecs = require("@elastic/ecs");
var _reactQuery = require("@kbn/react-query");
var _table_field_name_cell = require("../../../document_details/right/components/table_field_name_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/generic_right/components/fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isValidEcsField = fieldName => fieldName in _ecs.EcsFlat;
const getDescriptionDisplay = value => {
  if (value === undefined) return 'undefined';
  if (typeof value === 'boolean' || value === null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 12
      }
    }, JSON.stringify(value));
  }
  if (typeof value === 'object') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      overflowHeight: 300,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, JSON.stringify(value, null, 2));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 10
    }
  }, value);
};
const getSortedFlattenedItems = (document, pinnedFields) => {
  const flattenedItems = Object.entries((0, _std.getFlattenedObject)(document)).map(([key, value]) => ({
    key,
    value
  }));
  return flattenedItems.sort((a, b) => {
    const isAPinned = pinnedFields === null || pinnedFields === void 0 ? void 0 : pinnedFields.includes(a.key);
    const isBPinned = pinnedFields === null || pinnedFields === void 0 ? void 0 : pinnedFields.includes(b.key);
    if (isAPinned && !isBPinned) return -1;
    if (!isAPinned && isBPinned) return 1;
    return 0; // Keep original order if neither are pinned
  });
};
const getPinnedFieldsFromLocalStorage = storageKey => {
  const storedPinned = localStorage.getItem(storageKey);
  return storedPinned ? JSON.parse(storedPinned) : [];
};
const setPinnedFieldsInLocalStorage = (storageKey, fields) => {
  localStorage.setItem(storageKey, JSON.stringify(fields));
};
const usePinnedFields = (storageKey, defaultPinnedFields) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  (0, _react.useEffect)(() => {
    var _getPinnedFieldsFromL;
    const hasStoredPinnedFields = !!((_getPinnedFieldsFromL = getPinnedFieldsFromLocalStorage(storageKey)) !== null && _getPinnedFieldsFromL !== void 0 && _getPinnedFieldsFromL.length);
    const hasDefaultPinnedFields = !!(defaultPinnedFields !== null && defaultPinnedFields !== void 0 && defaultPinnedFields.length);

    // If no pinned fields exist in localStorage, set the default fields
    if (!hasStoredPinnedFields && hasDefaultPinnedFields) {
      setPinnedFieldsInLocalStorage(storageKey, defaultPinnedFields);
      queryClient.setQueryData(['pinnedFields', storageKey], defaultPinnedFields);
      queryClient.invalidateQueries(['pinnedFields', storageKey]);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    data: pinnedFields = []
  } = (0, _reactQuery.useQuery)({
    queryKey: ['pinnedFields', storageKey],
    queryFn: () => getPinnedFieldsFromLocalStorage(storageKey),
    initialData: getPinnedFieldsFromLocalStorage(storageKey) || []
  });
  const togglePin = fieldKey => {
    const updatedPinnedFields = pinnedFields.includes(fieldKey) ? pinnedFields.filter(key => key !== fieldKey) : [...pinnedFields, fieldKey];
    setPinnedFieldsInLocalStorage(storageKey, updatedPinnedFields);
    queryClient.setQueryData(['pinnedFields', storageKey], updatedPinnedFields);
    queryClient.invalidateQueries(['pinnedFields', storageKey]);
  };
  return {
    pinnedFields,
    togglePin
  };
};
exports.usePinnedFields = usePinnedFields;
/**
 * Displays a table of flattened fields and values with an option to pin items to the top.
 */
const FieldsTable = ({
  document,
  tableStorageKey,
  euiInMemoryTableProps,
  defaultPinnedFields
}) => {
  const {
    pinnedFields,
    togglePin
  } = usePinnedFields(tableStorageKey || 'fields-table-pins', defaultPinnedFields);
  const sortedItems = (0, _react.useMemo)(() => getSortedFlattenedItems(document, pinnedFields), [document, pinnedFields]);
  const columns = (0, _react.useMemo)(() => [...(tableStorageKey ? [{
    field: 'key',
    name: '',
    width: '40px',
    render: fieldKey => {
      const isPinned = pinnedFields === null || pinnedFields === void 0 ? void 0 : pinnedFields.includes(fieldKey);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: isPinned ? 'pinFilled' : 'pin',
        "aria-label": isPinned ? 'Unpin field' : 'Pin field',
        color: isPinned ? 'primary' : 'text',
        onClick: () => togglePin(fieldKey),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 19
        }
      });
    }
  }] : []), {
    field: 'key',
    name: _i18n.i18n.translate('xpack.securitySolution.fieldsTable.fieldColumnLabel', {
      defaultMessage: 'Field'
    }),
    width: '25%',
    render: (fieldName, flattenedItem) => {
      let dataType = typeof flattenedItem.value;
      if (isValidEcsField(fieldName)) {
        dataType = _ecs.EcsFlat[fieldName].type;
      }
      return /*#__PURE__*/_react.default.createElement(_table_field_name_cell.TableFieldNameCell, {
        field: fieldName,
        dataType: dataType,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 18
        }
      });
    }
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.securitySolution.fieldsTable.valueColumnLabel', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      css: {
        width: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 11
      }
    }, getDescriptionDisplay(value))
  }], [pinnedFields, tableStorageKey, togglePin]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, (0, _extends2.default)({
    // @ts-ignore
    items: sortedItems,
    columns: columns,
    sorting: {
      sort: {
        field: 'key',
        direction: 'asc'
      }
    },
    search: {
      box: {
        incremental: true
      }
    },
    pagination: {
      initialPageSize: 100,
      showPerPageOptions: false
    }
  }, euiInMemoryTableProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }));
};
exports.FieldsTable = FieldsTable;