"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventEnrichmentComplete = void 0;
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _search_strategy = require("../../../../../common/api/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * API call to retrieve the enrichments for a set of fields
 */
const getEventEnrichment = ({
  data,
  defaultIndex,
  eventFields,
  filterQuery,
  timerange,
  signal
}) => data.search.search({
  defaultIndex,
  eventFields,
  factoryQueryType: _search_strategy.CtiQueries.eventEnrichment,
  filterQuery,
  timerange
}, {
  strategy: 'securitySolutionSearchStrategy',
  abortSignal: signal
});

/**
 * Returns the enrichments for a set of fields, excluding the running response
 */
const getEventEnrichmentComplete = props => getEventEnrichment(props).pipe((0, _rxjs.filter)(response => !(0, _common.isRunningResponse)(response)));
const useEventEnrichmentComplete = () => (0, _securitysolutionHookUtils.useObservable)((0, _securitysolutionHookUtils.withOptionalSignal)(getEventEnrichmentComplete));
exports.useEventEnrichmentComplete = useEventEnrichmentComplete;