"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightsSummaryRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _left = require("../../left");
var _formatted_number = require("../../../../common/components/formatted_number");
var _use_navigate_to_left_panel = require("../../shared/hooks/use_navigate_to_left_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/insights_summary_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOADING = _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.insightSummaryLoadingAriaLabel', {
  defaultMessage: 'Loading'
});
const BUTTON = _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.insightSummaryButtonAriaLabel', {
  defaultMessage: 'Click to see more details'
});
/**
 * Panel showing summary information.
 * The default display is a text on the left and a count on the right, displayed with a clickable EuiBadge.
 * The left and right section can accept a ReactElement to allow for more complex display.
 * Should be used for Entities, Threat intelligence, Prevalence, Correlations and Results components under the Insights section.
 */
const InsightsSummaryRow = ({
  loading = false,
  error = false,
  value,
  text,
  expandedSubTab,
  'data-test-subj': dataTestSubj
}) => {
  const {
    navigateToLeftPanel: onClick,
    isEnabled: isLinkEnabled
  } = (0, _use_navigate_to_left_panel.useNavigateToLeftPanel)({
    tab: _left.LeftPanelInsightsTab,
    subTab: expandedSubTab
  });
  const textDataTestSubj = (0, _react.useMemo)(() => `${dataTestSubj}Text`, [dataTestSubj]);
  const loadingDataTestSubj = (0, _react.useMemo)(() => `${dataTestSubj}Loading`, [dataTestSubj]);
  const button = (0, _react.useMemo)(() => {
    const buttonDataTestSubj = `${dataTestSubj}Button`;
    const valueDataTestSubj = `${dataTestSubj}Value`;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof value === 'number' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": BUTTON,
      onClick: onClick,
      flush: 'both',
      size: "xs",
      disabled: !isLinkEnabled,
      "data-test-subj": buttonDataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    }))) : /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": valueDataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }, value));
  }, [dataTestSubj, onClick, value, isLinkEnabled]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1,
      size: "m",
      isLoading: loading,
      contentAriaLabel: LOADING,
      "data-test-subj": loadingDataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    });
  }
  if (error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: 'spaceBetween',
    alignItems: 'center',
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": textDataTestSubj,
    css: (0, _react2.css)`
          word-break: break-word;
          display: -webkit-box;
          -webkit-line-clamp: 1;
          -webkit-box-orient: vertical;
          overflow: hidden;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, text), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, button));
};
exports.InsightsSummaryRow = InsightsSummaryRow;
InsightsSummaryRow.displayName = 'InsightsSummaryRow';