"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AboutSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_expand_section = require("../hooks/use_expand_section");
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
var _alert_description = require("./alert_description");
var _reason = require("./reason");
var _mitre_attack = require("./mitre_attack");
var _utils = require("../../shared/utils");
var _event_kinds = require("../../shared/constants/event_kinds");
var _context = require("../../shared/context");
var _event_utils = require("../utils/event_utils");
var _event_category_description = require("./event_category_description");
var _event_kind_description = require("./event_kind_description");
var _event_renderer = require("./event_renderer");
var _alert_status = require("./alert_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/about_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KEY = 'about';

/**
 * Most top section of the overview tab.
 * For alerts (event.kind is signal), it contains the description, reason and mitre attack information.
 * For generic events (event.kind is event), it shows the event category description and event renderer.
 * For all other events, it shows the event kind description, a list of event categories and event renderer.
 */
const AboutSection = exports.AboutSection = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const eventKindInECS = eventKind && (0, _event_utils.isEcsAllowedValue)('event.kind', eventKind);
  const expanded = (0, _use_expand_section.useExpandSection)({
    title: KEY,
    defaultValue: true
  });
  const content = eventKind === _event_kinds.EventKind.signal ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_alert_description.AlertDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_reason.Reason, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_mitre_attack.MitreAttack, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_status.AlertStatus, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eventKindInECS && (eventKind === 'event' ?
  /*#__PURE__*/
  // if event kind is event, show a detailed description based on event category
  _react.default.createElement(_event_category_description.EventCategoryDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }) :
  /*#__PURE__*/
  // if event kind is not event, show a higher level description on event kind
  _react.default.createElement(_event_kind_description.EventKindDescription, {
    eventKind: eventKind,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_event_renderer.EventRenderer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.about.sectionTitle",
      defaultMessage: "About",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }),
    localStorageKey: KEY,
    gutterSize: "s",
    "data-test-subj": _test_ids.ABOUT_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, content);
});
AboutSection.displayName = 'AboutSection';