"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphVisualization = exports.GRAPH_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _cloudSecurityPostureGraph = require("@kbn/cloud-security-posture-graph");
var _v = require("@kbn/cloud-security-posture-common/schema/graph/v1");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_get_sourcerer_data_view = require("../../../../sourcerer/components/use_get_sourcerer_data_view");
var _model = require("../../../../sourcerer/store/model");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _use_graph_preview = require("../../shared/hooks/use_graph_preview");
var _use_investigate_in_timeline = require("../../../../common/hooks/timeline/use_investigate_in_timeline");
var _normalize_time_range = require("../../../../common/utils/normalize_time_range");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _panel_keys = require("../../shared/constants/panel_keys");
var _constants = require("../../preview/constants");
var _kibana = require("../../../../common/lib/kibana");
var _constants2 = require("../../../entity_details/shared/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/graph_visualization.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GraphInvestigationLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/cloud-security-posture-graph'))).then(module => ({
  default: module.GraphInvestigation
})));
const GRAPH_ID = exports.GRAPH_ID = 'graph-visualization';
const MAX_DOCUMENTS_TO_LOAD = 50;

/**
 * Graph visualization view displayed in the document details expandable flyout left section under the Visualize tab
 */
const GraphVisualization = exports.GraphVisualization = /*#__PURE__*/(0, _react.memo)(() => {
  const toasts = (0, _kibana.useToasts)();
  const oldDataView = (0, _use_get_sourcerer_data_view.useGetScopedSourcererDataView)({
    sourcererScope: _model.SourcererScopeName.default
  });
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.default);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const dataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  const dataViewIndexPattern = dataView ? dataView.getIndexPattern() : undefined;
  const {
    getFieldsData,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    eventIds,
    timestamp = new Date().toISOString(),
    isAlert
  } = (0, _use_graph_preview.useGraphPreview)({
    getFieldsData,
    ecsData: dataAsNestedObject,
    dataFormattedForFieldBrowser
  });
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const onOpenEventPreview = (0, _react.useCallback)(node => {
    const singleDocumentData = (0, _cloudSecurityPostureGraph.getSingleDocumentData)(node);
    const docMode = (0, _cloudSecurityPostureGraph.getNodeDocumentMode)(node);
    if ((docMode === 'single-event' || docMode === 'single-alert') && singleDocumentData) {
      openPreviewPanel({
        id: _panel_keys.DocumentDetailsPreviewPanelKey,
        params: {
          id: singleDocumentData.id,
          indexName: singleDocumentData.index,
          scopeId,
          banner: docMode === 'single-alert' ? _constants.ALERT_PREVIEW_BANNER : _constants.EVENT_PREVIEW_BANNER,
          isPreviewMode: true
        }
      });
    } else if (docMode === 'single-entity' && singleDocumentData) {
      openPreviewPanel({
        id: _constants2.GenericEntityPanelKey,
        params: {
          entityId: singleDocumentData.id,
          scopeId,
          isPreviewMode: true,
          banner: _constants.GENERIC_ENTITY_PREVIEW_BANNER
        }
      });
    } else if (docMode === 'grouped-entities' && node.documentsData) {
      openPreviewPanel({
        id: _cloudSecurityPostureGraph.GraphGroupedNodePreviewPanelKey,
        params: {
          id: node.id,
          scopeId,
          isPreviewMode: true,
          banner: _cloudSecurityPostureGraph.GROUP_PREVIEW_BANNER,
          docMode,
          entityItems: node.documentsData.slice(0, MAX_DOCUMENTS_TO_LOAD).map(doc => {
            var _doc$entity, _doc$entity2;
            return {
              itemType: _v.DOCUMENT_TYPE_ENTITY,
              id: doc.id,
              type: (_doc$entity = doc.entity) === null || _doc$entity === void 0 ? void 0 : _doc$entity.type,
              subType: (_doc$entity2 = doc.entity) === null || _doc$entity2 === void 0 ? void 0 : _doc$entity2.sub_type,
              icon: node.icon
            };
          })
        }
      });
    } else if (docMode === 'grouped-events' && node.documentsData) {
      openPreviewPanel({
        id: _cloudSecurityPostureGraph.GraphGroupedNodePreviewPanelKey,
        params: {
          id: node.id,
          scopeId,
          isPreviewMode: true,
          banner: _cloudSecurityPostureGraph.GROUP_PREVIEW_BANNER,
          docMode,
          dataViewId: dataViewIndexPattern,
          documentIds: node.documentsData.slice(0, MAX_DOCUMENTS_TO_LOAD).map(doc => {
            var _doc$event;
            return (_doc$event = doc.event) === null || _doc$event === void 0 ? void 0 : _doc$event.id;
          })
        }
      });
    } else {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.securitySolution.flyout.document_details.left.components.graphVisualization.errorOpenNodePreview', {
          defaultMessage: 'Failed showing preview'
        })
      });
    }
  }, [toasts, openPreviewPanel, scopeId, dataViewIndexPattern]);
  const originEventIds = eventIds.map(id => ({
    id,
    isAlert
  }));
  const {
    investigateInTimeline
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)();
  const openTimelineCallback = (0, _react.useCallback)((query, filters, timeRange) => {
    const from = _datemath.default.parse(timeRange.from);
    const to = _datemath.default.parse(timeRange.to);
    if (!from || !to) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.securitySolution.flyout.document_details.left.components.graphVisualization.errorInvalidTimeRange', {
          defaultMessage: 'Invalid time range'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.flyout.document_details.left.components.graphVisualization.errorInvalidTimeRangeDescription', {
          defaultMessage: 'Please select a valid time range.'
        })
      });
      return;
    }
    const normalizedTimeRange = (0, _normalize_time_range.normalizeTimeRange)({
      ...timeRange,
      from: from.toISOString(),
      to: to.toISOString()
    });
    investigateInTimeline({
      keepDataView: true,
      query,
      filters,
      timeRange: {
        from: normalizedTimeRange.from,
        to: normalizedTimeRange.to,
        kind: 'absolute'
      }
    });
  }, [investigateInTimeline, toasts]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.GRAPH_VISUALIZATION_TEST_ID,
    css: (0, _react2.css)`
        height: calc(100vh - 250px);
        min-height: 400px;
        width: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, dataView && /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 35
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(GraphInvestigationLazy, {
    initialState: {
      dataView,
      originEventIds,
      timeRange: {
        from: `${timestamp}||-30m`,
        to: `${timestamp}||+30m`
      }
    },
    showInvestigateInTimeline: true,
    showToggleSearch: true,
    onInvestigateInTimeline: openTimelineCallback,
    onOpenEventPreview: onOpenEventPreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  })));
});
GraphVisualization.displayName = 'GraphVisualization';