"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsMisconfigurationPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _i18n = require("@kbn/i18n");
var _flyout_navigation = require("../../../shared/components/flyout_navigation");
var _flyout_header = require("../../../shared/components/flyout_header");
var _kibana = require("../../../../common/lib/kibana");
var _formatted_date = require("../../../../common/components/formatted_date");
var _flyout_title = require("../../../shared/components/flyout_title");
var _flyout_body = require("../../../shared/components/flyout_body");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/csp_details/findings_flyout/findings_right/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FindingsMisconfigurationPanel = ({
  resourceId,
  ruleId,
  isPreviewMode
}) => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CspFlyout = cloudSecurityPosture.getCloudSecurityPostureMisconfigurationFlyout();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: false,
    isPreviewMode: isPreviewMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CspFlyout.Component, {
    ruleId: ruleId,
    resourceId: resourceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, ({
    finding,
    createRuleFn
  }) => {
    var _finding$result;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false,
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CspEvaluationBadge, {
      type: finding === null || finding === void 0 ? void 0 : (_finding$result = finding.result) === null || _finding$result === void 0 ? void 0 : _finding$result.evaluation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 21
      }
    })), finding['@timestamp'] && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 25
      }
    }, _i18n.i18n.translate('xpack.securitySolution.csp.findingsFlyout.evaluatedAt', {
      defaultMessage: 'Evaluated at '
    })), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(finding['@timestamp']),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 25
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 25
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
      title: finding.rule.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(CspFlyout.Header, {
      finding: finding,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(CspFlyout.Body, {
      finding: finding,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    })), !isPreviewMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(CspFlyout.Footer, {
      createRuleFn: createRuleFn,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 19
      }
    })));
  }));
};
exports.FindingsMisconfigurationPanel = FindingsMisconfigurationPanel;
FindingsMisconfigurationPanel.displayName = 'FindingsMisconfigurationPanel';