"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDestination = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _network = require("./network");
var _source_destination_with_arrows = require("./source_destination_with_arrows");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EuiFlexItemMarginTop = (0, _styled.default)(_eui.EuiFlexItem)`
  margin-top: 3px;
`;
EuiFlexItemMarginTop.displayName = 'EuiFlexItemMarginTop';

/**
 * Renders a visualization of network traffic between a source and a destination
 * This component is used by the Netflow row renderer
 */
const SourceDestination = exports.SourceDestination = /*#__PURE__*/_react.default.memo(({
  contextId,
  scopeId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventId,
  networkBytes,
  networkCommunityId,
  networkDirection,
  networkPackets,
  networkProtocol,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourceIp,
  sourcePackets,
  sourcePort,
  transport
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_network.Network, {
  scopeId: scopeId,
  bytes: networkBytes,
  packets: networkPackets,
  communityId: networkCommunityId,
  contextId: contextId,
  direction: networkDirection,
  eventId: eventId,
  protocol: networkProtocol,
  transport: transport,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginTop, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_source_destination_with_arrows.SourceDestinationWithArrows, {
  contextId: contextId,
  scopeId: scopeId,
  destinationBytes: destinationBytes,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPackets: destinationPackets,
  destinationPort: destinationPort,
  eventId: eventId,
  sourceBytes: sourceBytes,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePackets: sourcePackets,
  sourcePort: sourcePort,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 9
  }
}))));
SourceDestination.displayName = 'SourceDestination';