"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArrowHead = exports.ArrowBody = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/arrows/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/** Renders the body (non-pointy part) of an arrow */
const ArrowBody = exports.ArrowBody = _styled.default.span`
  background-color: ${props => props.theme.euiTheme.colors.lightShade};
  height: ${({
  height
}) => `${height}px`};
  width: 25px;
`;
ArrowBody.displayName = 'ArrowBody';
/** Renders the head of an arrow */
const ArrowHead = exports.ArrowHead = /*#__PURE__*/_react.default.memo(({
  direction
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  color: "subdued",
  "data-test-subj": "arrow-icon",
  size: "s",
  type: direction,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 3
  }
}));
ArrowHead.displayName = 'ArrowHead';