"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsQueryTabBody = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _hosts = require("../../containers/hosts");
var _hosts_table = require("../../components/hosts_table");
var _manage_query = require("../../../../common/components/page/manage_query");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/navigation/hosts_query_tab_body.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const HostsTableManage = (0, _manage_query.manageQuery)(_hosts_table.HostsTable);
const HostsQueryTabBody = ({
  deleteQuery,
  endDate,
  filterQuery,
  indexNames,
  skip,
  setQuery,
  startDate,
  type
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(_hosts.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const [loading, {
    hosts,
    totalCount,
    pageInfo,
    loadPage,
    id,
    inspect,
    isInspected,
    refetch
  }] = (0, _hosts.useAllHost)({
    endDate,
    filterQuery,
    indexNames,
    skip: querySkip,
    startDate,
    type
  });
  return /*#__PURE__*/_react.default.createElement(HostsTableManage, {
    deleteQuery: deleteQuery,
    data: hosts,
    fakeTotalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    id: id,
    inspect: inspect,
    isInspect: isInspected,
    loading: loading,
    loadPage: loadPage,
    refetch: refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: totalCount,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.HostsQueryTabBody = HostsQueryTabBody;
HostsQueryTabBody.displayName = 'HostsQueryTabBody';