"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskDetailsTabBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_upselling = require("../../../common/hooks/use_upselling");
var _enable_risk_score = require("../enable_risk_score");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../explore/hosts/store");
var _store2 = require("../../../explore/users/store");
var _manage_query = require("../../../common/components/page/manage_query");
var _top_risk_score_contributors_alerts = require("../top_risk_score_contributors_alerts");
var _query_toggle = require("../../../common/containers/query_toggle");
var _search_strategy = require("../../../../common/search_strategy");
var _utils = require("../../common/utils");
var _use_risk_score = require("../../api/hooks/use_risk_score");
var _use_missing_risk_engine_privileges = require("../../hooks/use_missing_risk_engine_privileges");
var _risk_engine_privileges_callout = require("../risk_engine_privileges_callout");
var _risk_score_no_data_detected = require("../risk_score_no_data_detected");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_details_tab_body/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  margin-top: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.l};
`;
const RiskDetailsTabBodyComponent = ({
  entityName,
  startDate,
  endDate,
  setQuery,
  deleteQuery,
  riskEntity
}) => {
  const queryId = (0, _react.useMemo)(() => riskEntity === _search_strategy.EntityType.host ? _utils.HostRiskScoreQueryId.HOST_DETAILS_RISK_SCORE : _utils.UserRiskScoreQueryId.USER_DETAILS_RISK_SCORE, [riskEntity]);
  const severitySelectionRedux = (0, _use_selector.useDeepEqualSelector)(state => riskEntity === _search_strategy.EntityType.host ? _store.hostsSelectors.hostRiskScoreSeverityFilterSelector()(state, _store.hostsModel.HostsType.details) : _store2.usersSelectors.userRiskScoreSeverityFilterSelector()(state));
  const timerange = (0, _react.useMemo)(() => ({
    from: startDate,
    to: endDate
  }), [startDate, endDate]);
  const {
    toggleStatus: contributorsToggleStatus,
    setToggleStatus: setContributorsToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`${queryId} contributors`);
  const filterQuery = (0, _react.useMemo)(() => entityName ? (0, _search_strategy.buildEntityNameFilter)(riskEntity, [entityName]) : {}, [entityName, riskEntity]);
  const {
    data,
    loading,
    refetch,
    inspect,
    hasEngineBeenInstalled
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    onlyLatest: false,
    riskEntity,
    skip: !contributorsToggleStatus,
    timerange
  });
  (0, _manage_query.useQueryInspector)({
    queryId,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  const toggleContributorsQuery = (0, _react.useCallback)(status => {
    setContributorsToggleStatus(status);
  }, [setContributorsToggleStatus]);
  const privileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)({
    readonly: true
  });
  const RiskScoreUpsell = (0, _use_upselling.useUpsellingComponent)('entity_analytics_panel');
  if (RiskScoreUpsell) {
    return /*#__PURE__*/_react.default.createElement(RiskScoreUpsell, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 12
      }
    });
  }
  if (!privileges.isLoading && !privileges.hasAllRequiredPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
      privileges: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));
  }
  const status = {
    isDisabled: !hasEngineBeenInstalled && !loading
  };
  if (status.isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_enable_risk_score.EnableRiskScore, (0, _extends2.default)({}, status, {
      entityType: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 12
      }
    }));
  }
  if (hasEngineBeenInstalled && severitySelectionRedux.length === 0 && data && data.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_risk_score_no_data_detected.RiskScoresNoDataDetected, {
      entityType: riskEntity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }, (data === null || data === void 0 ? void 0 : data[0]) && /*#__PURE__*/_react.default.createElement(_top_risk_score_contributors_alerts.TopRiskScoreContributorsAlerts, {
    toggleStatus: contributorsToggleStatus,
    toggleQuery: toggleContributorsQuery,
    riskScore: data[0],
    riskEntity: riskEntity,
    loading: loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }))));
};
RiskDetailsTabBodyComponent.displayName = 'RiskDetailsTabBodyComponent';
const RiskDetailsTabBody = exports.RiskDetailsTabBody = /*#__PURE__*/_react.default.memo(RiskDetailsTabBodyComponent);
RiskDetailsTabBody.displayName = 'RiskDetailsTabBody';