"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = exports.INITIAL_STATE = void 0;
var _types = require("./types");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE = exports.INITIAL_STATE = {
  isLoading: false,
  step: _types.FileUploaderSteps.FILE_PICKER
};
const reducer = (state, action) => {
  switch (action.type) {
    case 'resetState':
      return INITIAL_STATE;
    case 'loadingFile':
      if ((0, _helpers.isFilePickerStep)(state)) {
        return {
          ...state,
          isLoading: true,
          fileName: action.payload.fileName
        };
      }
      break;
    case 'fileError':
      return {
        isLoading: false,
        step: _types.FileUploaderSteps.FILE_PICKER,
        fileError: action.payload.message
      };
    case 'fileValidated':
      return {
        isLoading: false,
        step: _types.FileUploaderSteps.VALIDATION,
        ...action.payload
      };
    case 'uploadingFile':
      if ((0, _helpers.isValidationStep)(state)) {
        return {
          ...state,
          isLoading: true
        };
      }
      break;
    case 'fileUploaded':
      if ((0, _helpers.isValidationStep)(state)) {
        return {
          fileUploadResponse: action.payload.response,
          fileUploadError: action.payload.errorMessage,
          validLinesAsText: state.validatedFile.validLines.text,
          step: _types.FileUploaderSteps.RESULT
        };
      }
      break;
    case 'fileUploadError':
      if ((0, _helpers.isValidationStep)(state)) {
        return {
          fileUploadError: action.payload.errorMessage,
          step: _types.FileUploaderSteps.ERROR,
          fileUploadResponse: action.payload.response,
          validLinesAsText: state.validatedFile.validLines.text
        };
      }
      break;
  }
  return state;
};
exports.reducer = reducer;