"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidationStep = exports.isFilePickerStep = exports.isErrorStep = exports.getStepStatus = exports.buildAnnotationsFromError = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStepStatus = (step, currentStep) => {
  if (currentStep === _types.FileUploaderSteps.ERROR) {
    return 'disabled';
  }
  if (currentStep === step) {
    return 'current';
  }
  if (currentStep > step) {
    return 'complete';
  }
  return 'disabled';
};
exports.getStepStatus = getStepStatus;
const isFilePickerStep = state => state.step === _types.FileUploaderSteps.FILE_PICKER;
exports.isFilePickerStep = isFilePickerStep;
const isValidationStep = state => state.step === _types.FileUploaderSteps.VALIDATION;
exports.isValidationStep = isValidationStep;
const isErrorStep = state => state.step === _types.FileUploaderSteps.ERROR;
exports.isErrorStep = isErrorStep;
const buildAnnotationsFromError = errors => {
  const annotations = {};
  errors.forEach(e => {
    if (e.index !== undefined && e.index !== null) {
      annotations[e.index] = e.message;
    }
  });
  return annotations;
};
exports.buildAnnotationsFromError = buildAnnotationsFromError;