"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineComponentsStatusTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _basic_table = require("../../../../../../common/components/ml/tables/basic_table");
var _use_columns = require("../hooks/use_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/engines_status/components/engine_components_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const componentToId = ({
  id,
  resource
}) => `${resource}-${id}`;
const EngineComponentsStatusTable = ({
  components
}) => {
  const [expandedItems, setExpandedItems] = (0, _react.useState)([]);
  const itemIdToExpandedRowMap = (0, _react.useMemo)(() => {
    return expandedItems.reduce((acc, componentStatus) => {
      if (componentStatus.errors && componentStatus.errors.length > 0) {
        acc[componentToId(componentStatus)] = /*#__PURE__*/_react.default.createElement(TransformExtendedData, {
          errors: componentStatus.errors,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 29,
            columnNumber: 11
          }
        });
      }
      return acc;
    }, {});
  }, [expandedItems]);
  const onToggle = (0, _react.useCallback)(component => {
    const isItemExpanded = expandedItems.includes(component);
    if (isItemExpanded) {
      setExpandedItems(expandedItems.filter(item => component !== item));
    } else {
      setExpandedItems([...expandedItems, component]);
    }
  }, [expandedItems]);
  const columns = (0, _use_columns.useColumns)(onToggle, expandedItems);
  return /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
    "data-test-subj": "engine-components-status-table",
    columns: columns,
    itemId: componentToId,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    items: components,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
};
exports.EngineComponentsStatusTable = EngineComponentsStatusTable;
const TransformExtendedData = ({
  errors
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors === null || errors === void 0 ? void 0 : errors.map(({
    title,
    message
  }) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, message))));
};