"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isKnownEmptyQuery = isKnownEmptyQuery;
exports.useBulkActionsByTableType = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _use_bulk_alert_assignees_items = require("../../../common/components/toolbar/bulk_actions/use_bulk_alert_assignees_items");
var _use_bulk_alert_tags_items = require("../../../common/components/toolbar/bulk_actions/use_bulk_alert_tags_items");
var _model = require("../../../sourcerer/store/model");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_add_bulk_to_timeline = require("../../components/alerts_table/timeline_actions/use_add_bulk_to_timeline");
var _use_alert_actions = require("./use_alert_actions");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../../common/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// check to see if the query is a known "empty" shape
function isKnownEmptyQuery(query) {
  const queries = [
  // the default query used by the job wizards
  {
    bool: {
      must: [{
        match_all: {}
      }]
    }
  },
  // the default query used created by lens created jobs
  {
    bool: {
      filter: [],
      must: [{
        match_all: {}
      }],
      must_not: []
    }
  },
  // variations on the two previous queries
  {
    bool: {
      filter: [],
      must: [{
        match_all: {}
      }]
    }
  }, {
    bool: {
      must: [{
        match_all: {}
      }],
      must_not: []
    }
  },
  // the query generated by QA Framework created jobs
  {
    match_all: {}
  }];
  if (queries.some(q => (0, _lodash.isEqual)(q, query))) {
    return true;
  }
  return false;
}
function getFiltersForDSLQuery(datafeedQuery) {
  if (isKnownEmptyQuery(datafeedQuery)) {
    return [];
  }
  return [{
    meta: {
      negate: false,
      disabled: false,
      type: 'custom',
      value: JSON.stringify(datafeedQuery)
    },
    query: datafeedQuery
  }];
}
const useBulkActionsByTableType = (tableId, query, refresh) => {
  const {
    from,
    to
  } = (0, _use_global_time.useGlobalTime)();
  const filters = (0, _react.useMemo)(() => {
    return getFiltersForDSLQuery(query);
  }, [query]);
  const assigneeProps = (0, _react.useMemo)(() => {
    return {
      onAssigneesUpdate: refresh
    };
  }, [refresh]);
  const {
    alertAssigneesItems,
    alertAssigneesPanels
  } = (0, _use_bulk_alert_assignees_items.useBulkAlertAssigneesItems)(assigneeProps);
  const timelineActionParams = (0, _react.useMemo)(() => {
    return {
      localFilters: filters,
      from,
      to,
      scopeId: _model.SourcererScopeName.detections,
      tableId
    };
  }, [filters, from, to, tableId]);
  const getGlobalQueriesSelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const globalQueries = (0, _use_selector.useDeepEqualSelector)(getGlobalQueriesSelector);
  const refetch = (0, _react.useCallback)(() => {
    refresh();
    globalQueries.forEach(q => q.refetch && q.refetch());
  }, [globalQueries, refresh]);
  const alertActionParams = (0, _react.useMemo)(() => {
    return {
      scopeId: _model.SourcererScopeName.detections,
      filters,
      from,
      to,
      tableId,
      refetch
    };
  }, [from, to, filters, refetch, tableId]);
  const bulkAlertTagParams = (0, _react.useMemo)(() => {
    return {
      refetch: refresh
    };
  }, [refresh]);
  const {
    timelinePrivileges: {
      read: hasTimelineReadPrivilege
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const addBulkToTimelineAction = (0, _use_add_bulk_to_timeline.useAddBulkToTimelineAction)(timelineActionParams);
  const timelineActions = (0, _react.useMemo)(() => hasTimelineReadPrivilege ? [addBulkToTimelineAction] : [], [hasTimelineReadPrivilege, addBulkToTimelineAction]);
  const {
    items: alertActions,
    panels: alertActionsPanels
  } = (0, _use_alert_actions.useBulkAlertActionItems)(alertActionParams);
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_bulk_alert_tags_items.useBulkAlertTagsItems)(bulkAlertTagParams);
  const items = (0, _react.useMemo)(() => {
    return [...alertActions, ...timelineActions, ...alertTagsItems, ...alertAssigneesItems];
  }, [alertActions, alertTagsItems, timelineActions, alertAssigneesItems]);
  return (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items
    }, ...alertActionsPanels, ...alertTagsPanels, ...alertAssigneesPanels];
  }, [alertActionsPanels, alertTagsPanels, items, alertAssigneesPanels]);
};
exports.useBulkActionsByTableType = useBulkActionsByTableType;