"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoApiIntegrationKeyCallOut = exports.NO_INTEGRATION_CALLOUT_TEST_ID = exports.NO_INTEGRATION_CALLOUT_DISMISS_BUTTON_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _user_info = require("../user_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/callouts/no_api_integration_key_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_INTEGRATION_CALLOUT_TEST_ID = exports.NO_INTEGRATION_CALLOUT_TEST_ID = 'alerts-page-no-integration-callout';
const NO_INTEGRATION_CALLOUT_DISMISS_BUTTON_TEST_ID = exports.NO_INTEGRATION_CALLOUT_DISMISS_BUTTON_TEST_ID = 'alerts-page-no-integration-callout-dismiss-button';
const NO_API_INTEGRATION_KEY_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertsPage.noApiIntegrationKeyCallOut.titleLabel', {
  defaultMessage: 'API integration key required'
});
const NO_API_INTEGRATION_KEY_CALLOUT_MSG = _i18n.i18n.translate('xpack.securitySolution.alertsPage.noApiIntegrationKeyCallOut.messageLabel', {
  defaultMessage: `A new encryption key is generated for saved objects each time you start Kibana. Without a persistent key, you cannot delete or modify rules after Kibana restarts. To set a persistent key, add the xpack.encryptedSavedObjects.encryptionKey setting with any text value of 32 or more characters to the kibana.yml file.`
});
const DISMISS_CALLOUT = _i18n.i18n.translate('xpack.securitySolution.alertsPage.dismissNoApiIntegrationKey.buttonLabel', {
  defaultMessage: 'Dismiss'
});

/**
 * Show a callout if an API integration key is needed.
 * Users can dismiss the callout for the current browser tab.
 */
const NoApiIntegrationKeyCallOut = exports.NoApiIntegrationKeyCallOut = /*#__PURE__*/(0, _react.memo)(() => {
  const [isCalloutDismissed, setIsCalloutDismissed] = (0, _react.useState)(false);
  const dismissCallOut = (0, _react.useCallback)(() => setIsCalloutDismissed(true), [setIsCalloutDismissed]);
  const [{
    hasEncryptionKey
  }] = (0, _user_info.useUserData)();
  const showCallout = (0, _react.useMemo)(() => hasEncryptionKey != null && !hasEncryptionKey && !isCalloutDismissed, [hasEncryptionKey, isCalloutDismissed]);
  return showCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": NO_INTEGRATION_CALLOUT_TEST_ID,
    iconType: "warning",
    title: NO_API_INTEGRATION_KEY_CALLOUT_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, NO_API_INTEGRATION_KEY_CALLOUT_MSG), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    "data-test-subj": NO_INTEGRATION_CALLOUT_DISMISS_BUTTON_TEST_ID,
    onClick: dismissCallOut,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, DISMISS_CALLOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }));
});
NoApiIntegrationKeyCallOut.displayName = 'NoApiIntegrationKeyCallOut';