"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEventFilterAction = void 0;
var _react = require("react");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEventFilterAction = ({
  onAddEventFilterClick,
  disabled = false,
  tooltipMessage
}) => {
  const eventFilterActionItems = (0, _react.useMemo)(() => [{
    key: 'add-event-filter-menu-item',
    'data-test-subj': 'add-event-filter-menu-item',
    onClick: onAddEventFilterClick,
    disabled,
    toolTipContent: tooltipMessage,
    name: _translations.ACTION_ADD_EVENT_FILTER
  }], [onAddEventFilterClick, disabled, tooltipMessage]);
  return {
    eventFilterActionItems
  };
};
exports.useEventFilterAction = useEventFilterAction;