"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenBucket = void 0;
var _ecs_safety_helpers = require("../../../../../../../../common/endpoint/models/ecs_safety_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flattenBucket = ({
  bucket,
  maxRiskSubAggregations
}) => {
  var _bucket$stackByField, _bucket$stackByField2, _bucket$stackByField3;
  return (_bucket$stackByField = (_bucket$stackByField2 = bucket.stackByField1) === null || _bucket$stackByField2 === void 0 ? void 0 : (_bucket$stackByField3 = _bucket$stackByField2.buckets) === null || _bucket$stackByField3 === void 0 ? void 0 : _bucket$stackByField3.map(x => {
    var _bucket$key_as_string, _x$key_as_string;
    return {
      doc_count: bucket.doc_count,
      key: (_bucket$key_as_string = bucket.key_as_string) !== null && _bucket$key_as_string !== void 0 ? _bucket$key_as_string : bucket.key,
      // prefer key_as_string when available, because it contains a formatted date
      maxRiskSubAggregation: bucket.maxRiskSubAggregation,
      stackByField1Key: (_x$key_as_string = x.key_as_string) !== null && _x$key_as_string !== void 0 ? _x$key_as_string : (0, _ecs_safety_helpers.firstNonNullValue)(x.key),
      stackByField1DocCount: x.doc_count
    };
  })) !== null && _bucket$stackByField !== void 0 ? _bucket$stackByField : [];
};
exports.flattenBucket = flattenBucket;