"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showInitialLoadingSpinner = exports.createResetGroupByFieldAction = exports.createGenericSubtitle = exports.createEmbeddedDataSubtitle = void 0;
var _translations = require("../chart_panels/chart_settings_popover/configurations/default/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns `true` when the alerts histogram initial loading spinner should be shown
 *
 * @param isInitialLoading The loading spinner will only be displayed if this value is `true`, because after initial load, a different, non-spinner loading indicator is displayed
 * @param isLoadingAlerts When `true`, IO is being performed to request alerts (for rendering in the histogram)
 */
const showInitialLoadingSpinner = ({
  isInitialLoading,
  isLoadingAlerts
}) => isInitialLoading && isLoadingAlerts;
exports.showInitialLoadingSpinner = showInitialLoadingSpinner;
const createResetGroupByFieldAction = ({
  callback,
  order
} = {}) => ({
  id: 'resetGroupByField',
  getDisplayName() {
    return _translations.RESET_GROUP_BY_FIELDS;
  },
  getIconType() {
    return 'editorRedo';
  },
  type: 'actionButton',
  async isCompatible() {
    return true;
  },
  async execute({
    embeddable
  }) {
    callback === null || callback === void 0 ? void 0 : callback();
    const input = embeddable.getInput();
    const {
      attributes: {
        state: {
          visualization: {
            columns
          }
        }
      }
    } = input;

    // Unhide all the columns
    embeddable.updateInput({
      ...input,
      attributes: {
        ...input.attributes,
        state: {
          ...input.attributes.state,
          visualization: {
            ...input.attributes.state.visualization,
            columns: columns.map(c => ({
              ...c,
              hidden: false
            }))
          }
        }
      }
    });
  },
  order
});
exports.createResetGroupByFieldAction = createResetGroupByFieldAction;
const createGenericSubtitle = (isInitialLoading, showTotalAlertsCount, totalAlerts) => !isInitialLoading && showTotalAlertsCount && totalAlerts;
exports.createGenericSubtitle = createGenericSubtitle;
const createEmbeddedDataSubtitle = (embeddedDataAvailable, totalAlerts) => embeddedDataAvailable && totalAlerts;
exports.createEmbeddedDataSubtitle = createEmbeddedDataSubtitle;