"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellValue = void 0;
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../constants");
var _datetime_schema_cell_renderer = require("./datetime_schema_cell_renderer");
var _basic_cell_renderer = require("./basic_cell_renderer");
var _kibana_alert_severity_cell_renderer = require("./kibana_alert_severity_cell_renderer");
var _kibana_alert_related_integrations_cell_renderer = require("./kibana_alert_related_integrations_cell_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/render_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DATETIME_SCHEMA = 'datetime';
/**
 * Component used in the AI for SOC alert summary table.
 * It renders some of the value with custom renderers for some specific columns:
 *  - kibana.alert.rule.parameters
 *  - kibana.alert.severity
 * It also renders some schema types specifically (this property come from EuiDataGrid):
 *  - datetime
 * Finally it renders the rest as basic strings.
 */
const CellValue = exports.CellValue = /*#__PURE__*/(0, _react.memo)(({
  alert,
  columnId,
  packages,
  schema
}) => {
  let component;
  if (columnId === _constants.RELATED_INTEGRATION) {
    component = /*#__PURE__*/_react.default.createElement(_kibana_alert_related_integrations_cell_renderer.KibanaAlertRelatedIntegrationsCellRenderer, {
      alert: alert,
      packages: packages,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 17
      }
    });
  } else if (columnId === _ruleDataUtils.ALERT_SEVERITY) {
    component = /*#__PURE__*/_react.default.createElement(_kibana_alert_severity_cell_renderer.KibanaAlertSeverityCellRenderer, {
      alert: alert,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 17
      }
    });
  } else if (schema === DATETIME_SCHEMA) {
    component = /*#__PURE__*/_react.default.createElement(_datetime_schema_cell_renderer.DatetimeSchemaCellRenderer, {
      alert: alert,
      field: columnId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 17
      }
    });
  } else {
    component = /*#__PURE__*/_react.default.createElement(_basic_cell_renderer.BasicCellRenderer, {
      alert: alert,
      field: columnId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, component);
});
CellValue.displayName = 'CellValue';