"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiselectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_bool_state = require("../../../../../../common/hooks/use_bool_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/basic/filters/multiselect_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/* eslint-disable react/no-unused-prop-types */

/* eslint-enable react/no-unused-prop-types */

/**
 * @deprecated Please use [MultiselectFilter](../../../../../../common/components/multiselect_filter/index.tsx) instead.
 */
const MultiselectFilterComponent = props => {
  const {
    dataTestSubj,
    title,
    items,
    selectedItems,
    onSelectionChange,
    renderItem,
    renderLabel
  } = initializeProps(props);
  const [isPopoverOpen,, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const handleItemClick = (0, _react.useCallback)(item => {
    const newSelectedItems = selectedItems.includes(item) ? selectedItems.filter(i => i !== item) : [...selectedItems, item];
    onSelectionChange(newSelectedItems);
  }, [selectedItems, onSelectionChange]);
  const filterItemElements = (0, _react.useMemo)(() => {
    return items.map((item, index) => {
      const itemLabel = renderLabel(item);
      const itemElement = renderItem(item);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
        "data-test-subj": `${dataTestSubj}-item`,
        title: itemLabel,
        key: `${index}-${itemLabel}`,
        checked: selectedItems.includes(item) ? 'on' : undefined,
        onClick: () => handleItemClick(item),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 9
        }
      }, itemElement);
    });
  }, [dataTestSubj, items, selectedItems, renderItem, renderLabel, handleItemClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": `${dataTestSubj}-popover`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": `${dataTestSubj}-popoverButton`,
      iconType: "arrowDown",
      grow: false,
      numFilters: items.length,
      numActiveFilters: selectedItems.length,
      hasActiveFilters: selectedItems.length > 0,
      isSelected: isPopoverOpen,
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }, title),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, filterItemElements));
};

// We have to wrap it in a function and cast to original type because React.memo
// returns a component type which is not generic.
const enhanceMultiselectFilterComponent = () => {
  const Component = /*#__PURE__*/_react.default.memo(MultiselectFilterComponent);
  Component.displayName = 'MultiselectFilter';
  return Component;
};
const MultiselectFilter = exports.MultiselectFilter = enhanceMultiselectFilterComponent();
const initializeProps = props => {
  var _props$onSelectionCha, _props$renderLabel, _props$renderItem, _props$dataTestSubj;
  const onSelectionChange = (_props$onSelectionCha = props.onSelectionChange) !== null && _props$onSelectionCha !== void 0 ? _props$onSelectionCha : _lodash.noop;
  const renderLabel = (_props$renderLabel = props.renderLabel) !== null && _props$renderLabel !== void 0 ? _props$renderLabel : String;
  const renderItem = (_props$renderItem = props.renderItem) !== null && _props$renderItem !== void 0 ? _props$renderItem : renderLabel;
  return {
    dataTestSubj: (_props$dataTestSubj = props.dataTestSubj) !== null && _props$dataTestSubj !== void 0 ? _props$dataTestSubj : 'multiselectFilter',
    title: props.title,
    items: props.items,
    selectedItems: props.selectedItems,
    onSelectionChange,
    renderLabel,
    renderItem
  };
};