"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableContextOptional = exports.useRulesTableContext = exports.RulesTableContextProvider = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../../../../rule_gaps/api/hooks/utils");
var _use_fetch_rules_snooze_settings_query = require("../../../../rule_management/api/hooks/use_fetch_rules_snooze_settings_query");
var _use_get_gaps_summary_by_rule_id = require("../../../../rule_gaps/api/hooks/use_get_gaps_summary_by_rule_id");
var _constants = require("../../../../../../common/constants");
var _invariant = require("../../../../../../common/utils/invariant");
var _use_url_state = require("../../../../../common/hooks/use_url_state");
var _kibana = require("../../../../../common/lib/kibana");
var _helpers = require("../../../../../common/utils/global_query_string/helpers");
var _use_find_rules = require("../../../../rule_management/logic/use_find_rules");
var _constants2 = require("../constants");
var _rules_table_defaults = require("./rules_table_defaults");
var _rules_table_saved_state = require("./rules_table_saved_state");
var _use_rules_table_saved_state = require("./use_rules_table_saved_state");
var _constants3 = require("../../../../rule_gaps/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/rules_table/rules_table_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
const RulesTableContextProvider = ({
  children
}) => {
  var _savedFilter$searchTe, _savedFilter$tags, _savedFilter$ruleExec, _savedSorting$field, _savedSorting$order, _savedPagination$page, _savedPagination$perP, _filterOptions$gapSea2;
  const [autoRefreshSettings] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_RULES_TABLE_REFRESH_SETTING);
  const {
    sessionStorage
  } = (0, _kibana.useKibana)().services;
  const {
    filter: savedFilter,
    sorting: savedSorting,
    pagination: savedPagination
  } = (0, _use_rules_table_saved_state.useRulesTableSavedState)();
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    filter: (_savedFilter$searchTe = savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.searchTerm) !== null && _savedFilter$searchTe !== void 0 ? _savedFilter$searchTe : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.filter,
    tags: (_savedFilter$tags = savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.tags) !== null && _savedFilter$tags !== void 0 ? _savedFilter$tags : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.tags,
    showCustomRules: savedFilter !== null && savedFilter !== void 0 && savedFilter.source ? savedFilter.source === _rules_table_saved_state.RuleSource.Custom : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showCustomRules,
    showElasticRules: savedFilter !== null && savedFilter !== void 0 && savedFilter.source ? savedFilter.source === _rules_table_saved_state.RuleSource.Prebuilt : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showElasticRules,
    enabled: savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.enabled,
    ruleExecutionStatus: (_savedFilter$ruleExec = savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.ruleExecutionStatus) !== null && _savedFilter$ruleExec !== void 0 ? _savedFilter$ruleExec : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.ruleExecutionStatus,
    gapSearchRange: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.gapSearchRange,
    showRulesWithGaps: false
  });
  const [sortingOptions, setSortingOptions] = (0, _react.useState)({
    field: (_savedSorting$field = savedSorting === null || savedSorting === void 0 ? void 0 : savedSorting.field) !== null && _savedSorting$field !== void 0 ? _savedSorting$field : _rules_table_defaults.DEFAULT_SORTING_OPTIONS.field,
    order: (_savedSorting$order = savedSorting === null || savedSorting === void 0 ? void 0 : savedSorting.order) !== null && _savedSorting$order !== void 0 ? _savedSorting$order : _rules_table_defaults.DEFAULT_SORTING_OPTIONS.order
  });
  const [isAllSelected, setIsAllSelected] = (0, _react.useState)(false);
  const [isRefreshOn, setIsRefreshOn] = (0, _react.useState)(autoRefreshSettings.on);
  const [loadingRules, setLoadingRules] = (0, _react.useState)({
    ids: [],
    action: null
  });
  const [isPreflightInProgress, setIsPreflightInProgress] = (0, _react.useState)(false);
  const [page, setPage] = (0, _react.useState)((_savedPagination$page = savedPagination === null || savedPagination === void 0 ? void 0 : savedPagination.page) !== null && _savedPagination$page !== void 0 ? _savedPagination$page : _rules_table_defaults.DEFAULT_PAGE);
  const [perPage, setPerPage] = (0, _react.useState)((_savedPagination$perP = savedPagination === null || savedPagination === void 0 ? void 0 : savedPagination.perPage) !== null && _savedPagination$perP !== void 0 ? _savedPagination$perP : _rules_table_defaults.DEFAULT_RULES_PER_PAGE);
  const [selectedRuleIds, setSelectedRuleIds] = (0, _react.useState)([]);
  const [gapRangeForSearch, setGapRangeForSearch] = (0, _react.useState)();
  const autoRefreshBeforePause = (0, _react.useRef)(null);
  const isActionInProgress = loadingRules.ids.length > 0;
  const pagination = (0, _react.useMemo)(() => ({
    page,
    perPage
  }), [page, perPage]);
  const handleFilterOptionsChange = (0, _react.useCallback)(newFilter => {
    setFilterOptions(currentFilter => ({
      ...currentFilter,
      ...newFilter
    }));
    setPage(1);
    setSelectedRuleIds([]);
    setIsAllSelected(false);
  }, []);
  const clearRulesSelection = (0, _react.useCallback)(() => {
    setSelectedRuleIds([]);
    setIsAllSelected(false);
  }, []);
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  const clearFilters = (0, _react.useCallback)(() => {
    setFilterOptions({
      filter: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.filter,
      showElasticRules: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showElasticRules,
      showCustomRules: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showCustomRules,
      tags: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.tags,
      enabled: undefined,
      ruleExecutionStatus: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.ruleExecutionStatus
    });
    setSortingOptions({
      field: _rules_table_defaults.DEFAULT_SORTING_OPTIONS.field,
      order: _rules_table_defaults.DEFAULT_SORTING_OPTIONS.order
    });
    setPage(_rules_table_defaults.DEFAULT_PAGE);
    setPerPage(_rules_table_defaults.DEFAULT_RULES_PER_PAGE);
    replaceUrlParams({
      [_use_url_state.URL_PARAM_KEY.rulesTable]: null
    });
    sessionStorage.remove(_constants2.RULES_TABLE_STATE_STORAGE_KEY);
  }, [setFilterOptions, setSortingOptions, setPage, setPerPage, replaceUrlParams, sessionStorage]);
  (0, _react.useEffect)(() => {
    // pause table auto refresh when any of rule selected
    // store current auto refresh value, to use it later, when all rules selection will be cleared
    if (selectedRuleIds.length > 0) {
      setIsRefreshOn(false);
      if (autoRefreshBeforePause.current == null) {
        autoRefreshBeforePause.current = isRefreshOn;
      }
    } else {
      var _autoRefreshBeforePau;
      // if no rules selected, update auto refresh value, with previously stored value
      setIsRefreshOn((_autoRefreshBeforePau = autoRefreshBeforePause.current) !== null && _autoRefreshBeforePau !== void 0 ? _autoRefreshBeforePau : isRefreshOn);
      autoRefreshBeforePause.current = null;
    }
  }, [selectedRuleIds, isRefreshOn]);
  (0, _react.useEffect)(() => {
    if (filterOptions.showRulesWithGaps) {
      var _filterOptions$gapSea;
      setGapRangeForSearch((0, _utils.getGapRange)((_filterOptions$gapSea = filterOptions.gapSearchRange) !== null && _filterOptions$gapSea !== void 0 ? _filterOptions$gapSea : _constants3.defaultRangeValue));
    } else {
      setGapRangeForSearch(undefined);
    }
  }, [filterOptions.showRulesWithGaps, filterOptions.gapSearchRange]);

  // Fetch rules
  const {
    data: {
      rules,
      total
    } = {
      rules: [],
      total: 0
    },
    refetch,
    dataUpdatedAt,
    isFetched,
    isFetching,
    isLoading,
    isRefetching
  } = (0, _use_find_rules.useFindRules)({
    filterOptions,
    sortingOptions,
    pagination,
    ...(gapRangeForSearch ? {
      gapsRange: gapRangeForSearch
    } : {})
  }, {
    // We don't need refreshes on windows focus and reconnects if auto-refresh if off
    refetchOnWindowFocus: isRefreshOn && !isActionInProgress,
    refetchOnReconnect: isRefreshOn && !isActionInProgress,
    refetchInterval: isRefreshOn && !isActionInProgress && autoRefreshSettings.value,
    keepPreviousData: true // Use this option so that the state doesn't jump between "success" and "loading" on page change
  });

  // Fetch rules snooze settings
  const {
    data: rulesSnoozeSettingsMap,
    isLoading: isSnoozeSettingsLoading,
    isFetching: isSnoozeSettingsFetching,
    isError: isSnoozeSettingsFetchError,
    refetch: refetchSnoozeSettings
  } = (0, _use_fetch_rules_snooze_settings_query.useFetchRulesSnoozeSettingsQuery)(rules.map(x => x.id), {
    enabled: rules.length > 0
  });
  const {
    data: rulesGapInfoByRuleIds,
    refetch: refetchGapInfo
  } = (0, _use_get_gaps_summary_by_rule_id.useGetGapsSummaryByRuleIds)({
    ruleIds: rules.map(x => x.id),
    gapRange: (_filterOptions$gapSea2 = filterOptions.gapSearchRange) !== null && _filterOptions$gapSea2 !== void 0 ? _filterOptions$gapSea2 : _constants3.defaultRangeValue
  }, {
    enabled: rules.length > 0
  });
  const refetchRulesAndRelatedData = (0, _react.useCallback)(async () => {
    const response = await refetch();
    await Promise.allSettled([refetchSnoozeSettings(), refetchGapInfo()]);
    return response;
  }, [refetch, refetchSnoozeSettings, refetchGapInfo]);
  const actions = (0, _react.useMemo)(() => ({
    reFetchRules: refetchRulesAndRelatedData,
    setFilterOptions: handleFilterOptionsChange,
    setIsAllSelected,
    setIsRefreshOn,
    setLoadingRules,
    setPage,
    setPerPage,
    setSelectedRuleIds,
    setSortingOptions,
    clearRulesSelection,
    setIsPreflightInProgress,
    clearFilters
  }), [refetchRulesAndRelatedData, handleFilterOptionsChange, setIsAllSelected, setIsRefreshOn, setLoadingRules, setPage, setPerPage, setSelectedRuleIds, setSortingOptions, clearRulesSelection, setIsPreflightInProgress, clearFilters]);
  const enrichedRules = (0, _react.useMemo)(() => {
    return rules.map(rule => {
      var _rulesGapInfoByRuleId;
      const gapInfo = rulesGapInfoByRuleIds === null || rulesGapInfoByRuleIds === void 0 ? void 0 : (_rulesGapInfoByRuleId = rulesGapInfoByRuleIds.data) === null || _rulesGapInfoByRuleId === void 0 ? void 0 : _rulesGapInfoByRuleId.find(x => x.rule_id === rule.id);
      return {
        ...rule,
        gap_info: gapInfo
      };
    });
  }, [rules, rulesGapInfoByRuleIds]);
  const providerValue = (0, _react.useMemo)(() => {
    return {
      state: {
        rules: enrichedRules,
        rulesSnoozeSettings: {
          data: rulesSnoozeSettingsMap !== null && rulesSnoozeSettingsMap !== void 0 ? rulesSnoozeSettingsMap : {},
          isLoading: isSnoozeSettingsLoading,
          isFetching: isSnoozeSettingsFetching,
          isError: isSnoozeSettingsFetchError
        },
        pagination: {
          page,
          perPage,
          total
        },
        filterOptions,
        isPreflightInProgress,
        isActionInProgress,
        isAllSelected,
        isFetched,
        isFetching,
        isLoading,
        isRefetching,
        isRefreshOn,
        lastUpdated: dataUpdatedAt,
        loadingRuleIds: loadingRules.ids,
        loadingRulesAction: loadingRules.action,
        selectedRuleIds,
        sortingOptions,
        isDefault: isDefaultState(filterOptions, sortingOptions, {
          page,
          perPage,
          total
        })
      },
      actions
    };
  }, [enrichedRules, rulesSnoozeSettingsMap, isSnoozeSettingsLoading, isSnoozeSettingsFetching, isSnoozeSettingsFetchError, page, perPage, total, filterOptions, isPreflightInProgress, isActionInProgress, isAllSelected, isFetched, isFetching, isLoading, isRefetching, isRefreshOn, dataUpdatedAt, loadingRules.ids, loadingRules.action, selectedRuleIds, sortingOptions, actions]);
  return /*#__PURE__*/_react.default.createElement(RulesTableContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 10
    }
  }, children);
};
exports.RulesTableContextProvider = RulesTableContextProvider;
const useRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(RulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useRulesTableContext should be used inside RulesTableContextProvider');
  return rulesTableContext;
};
exports.useRulesTableContext = useRulesTableContext;
const useRulesTableContextOptional = () => (0, _react.useContext)(RulesTableContext);
exports.useRulesTableContextOptional = useRulesTableContextOptional;
function isDefaultState(filter, sorting, pagination) {
  return (0, _lodash.isEqual)(filter, _rules_table_defaults.DEFAULT_FILTER_OPTIONS) && (0, _lodash.isEqual)(sorting, _rules_table_defaults.DEFAULT_SORTING_OPTIONS) && pagination.page === _rules_table_defaults.DEFAULT_PAGE && pagination.perPage === _rules_table_defaults.DEFAULT_RULES_PER_PAGE;
}