"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleImportModal = RuleImportModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _logic = require("../../../rule_management/logic");
var _utils = require("./utils");
var _action_connectors_warning = require("./action_connectors_warning");
var _import_data_modal = require("../../../../common/components/import_data_modal");
var _use_find_rules_query = require("../../../rule_management/api/hooks/use_find_rules_query");
var _use_fetch_coverage_overview_query = require("../../../rule_management/api/hooks/use_fetch_coverage_overview_query");
var _use_fetch_rule_management_filters_query = require("../../../rule_management/api/hooks/use_fetch_rule_management_filters_query");
var _kibana = require("../../../../common/lib/kibana");
var i18nCommon = _interopRequireWildcard(require("../../../common/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_fetch_prebuilt_rule_base_version_query = require("../../../rule_management/api/hooks/prebuilt_rules/use_fetch_prebuilt_rule_base_version_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rule_import_modal/rule_import_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RuleImportModal({
  isImportModalVisible,
  hideImportModal
}) {
  const toasts = (0, _kibana.useToasts)();
  const [overwrite, setOverwrite] = (0, _react.useState)(false);
  const [overwriteExceptions, setOverwriteExceptions] = (0, _react.useState)(false);
  const [overwriteActionConnectors, setOverwriteActionConnectors] = (0, _react.useState)(false);
  const [actionConnectorsWarnings, setActionConnectorsWarnings] = (0, _react.useState)([]);
  const [importedActionConnectorsCount, setImportedActionConnectorsCount] = (0, _react.useState)(0);
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchCoverageOverviewQuery = (0, _use_fetch_coverage_overview_query.useInvalidateFetchCoverageOverviewQuery)();
  const invalidateFetchRuleManagementFilters = (0, _use_fetch_rule_management_filters_query.useInvalidateFetchRuleManagementFiltersQuery)();
  const invalidateFetchPrebuiltRuleBaseVerison = (0, _use_fetch_prebuilt_rule_base_version_query.useInvalidateFetchPrebuiltRuleBaseVersionQuery)();
  const invalidateRules = (0, _react.useCallback)(() => {
    invalidateFindRulesQuery();
    invalidateFetchRuleManagementFilters();
    invalidateFetchCoverageOverviewQuery();
    invalidateFetchPrebuiltRuleBaseVerison();
  }, [invalidateFindRulesQuery, invalidateFetchRuleManagementFilters, invalidateFetchCoverageOverviewQuery, invalidateFetchPrebuiltRuleBaseVerison]);
  const handleModalClose = (0, _react.useCallback)(() => {
    hideImportModal();
    setOverwrite(false);
    setOverwriteExceptions(false);
    setOverwriteActionConnectors(false);
    setActionConnectorsWarnings([]);
  }, [hideImportModal]);
  const handleImportComplete = (0, _react.useCallback)(importResponse => {
    (0, _utils.showToast)({
      importResponse,
      toasts
    });
    invalidateRules();
    if (!importResponse.action_connectors_warnings.length) {
      handleModalClose();
    }
  }, [toasts, handleModalClose, invalidateRules]);
  const handleRuleImport = (0, _react.useCallback)(async ({
    fileToImport,
    signal
  }) => {
    const importResponse = await (0, _logic.importRules)({
      fileToImport,
      signal,
      overwrite,
      overwriteExceptions,
      overwriteActionConnectors
    });
    const connectorsCount = importResponse.action_connectors_success_count;
    setActionConnectorsWarnings(importResponse.action_connectors_warnings);
    setImportedActionConnectorsCount(connectorsCount);
    return importResponse;
  }, [overwrite, overwriteActionConnectors, overwriteExceptions]);
  const handleCheckboxClick = (0, _react.useCallback)(() => {
    setOverwrite(shouldOverwrite => !shouldOverwrite);
  }, []);
  const handleExceptionsCheckboxClick = (0, _react.useCallback)(() => {
    setOverwriteExceptions(shouldOverwrite => !shouldOverwrite);
  }, []);
  const handleActionConnectorsCheckboxClick = (0, _react.useCallback)(() => {
    setOverwriteActionConnectors(shouldOverwrite => !shouldOverwrite);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_import_data_modal.ImportDataModal, {
    isModalVisible: isImportModalVisible,
    closeModal: handleModalClose,
    title: i18nCommon.IMPORT_RULE,
    filePickerPrompt: i18n.INITIAL_PROMPT_TEXT,
    description: i18n.SELECT_RULE,
    submitBtnText: i18n.IMPORT_RULE_BTN_TITLE,
    errorMessage: i18n.RULE_IMPORT_FAILED,
    importData: handleRuleImport,
    onImportComplete: handleImportComplete,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_action_connectors_warning.ActionConnectorWarnings, {
    actionConnectorsWarnings: actionConnectorsWarnings,
    importedActionConnectorsCount: importedActionConnectorsCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalCheckboxLabel",
    id: "importDataModalCheckboxLabel",
    label: i18n.OVERWRITE_WITH_SAME_NAME,
    checked: overwrite,
    onChange: handleCheckboxClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalExceptionsCheckboxLabel",
    id: "importDataModalExceptionsCheckboxLabel",
    label: i18n.OVERWRITE_EXCEPTIONS_LABEL,
    checked: overwriteExceptions,
    onChange: handleExceptionsCheckboxClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "importDataModalActionConnectorsCheckbox",
    id: "importDataModalActionConnectorsCheckbox",
    label: i18n.OVERWRITE_ACTION_CONNECTORS_LABEL,
    checked: overwriteActionConnectors,
    onChange: handleActionConnectorsCheckboxClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  })));
}