"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreEdit = RiskScoreEdit;
exports.riskScoreDeserializer = riskScoreDeserializer;
exports.riskScoreSchema = void 0;
exports.riskScoreSerializer = riskScoreSerializer;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _default_risk_score = require("../../../../../../rule_creation_ui/components/risk_score_mapping/default_risk_score");
var _default_risk_score_validator = require("../../../../../../rule_creation_ui/validators/default_risk_score_validator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/risk_score.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const riskScoreSchema = exports.riskScoreSchema = {
  riskScore: {
    validations: [{
      validator: ({
        path,
        value
      }) => (0, _default_risk_score_validator.defaultRiskScoreValidator)(value, path)
    }]
  }
};
function RiskScoreEdit() {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "riskScore",
    component: RiskScoreEditField,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 10
    }
  });
}
function RiskScoreEditField({
  field
}) {
  var _getFieldValidityAndE;
  const {
    value,
    setValue
  } = field;
  const errorMessage = (_getFieldValidityAndE = (0, _shared_imports.getFieldValidityAndErrorMessage)(field).errorMessage) !== null && _getFieldValidityAndE !== void 0 ? _getFieldValidityAndE : undefined;
  return /*#__PURE__*/_react.default.createElement(_default_risk_score.DefaultRiskScore, {
    value: value,
    onChange: setValue,
    errorMessage: errorMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 10
    }
  });
}
function riskScoreDeserializer(defaultValue) {
  return {
    riskScore: defaultValue.risk_score
  };
}
function riskScoreSerializer(formData) {
  return {
    risk_score: formData.riskScore
  };
}