"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceEdit = DataSourceEdit;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _prebuilt_rules = require("../../../../../../../../../common/api/detection_engine/prebuilt_rules");
var _shared_imports = require("../../../../../../../../shared_imports");
var _index_pattern_edit = require("./index_pattern_edit");
var _data_source_info_text = require("./data_source_info_text");
var _data_view_field = require("./data_view_field");
var _data_source_type_selector_field = require("./data_source_type_selector_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/data_source/data_source_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DataSourceEdit({
  resetForm
}) {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      type: {
        path: 'type'
      },
      indexPatterns: {
        path: 'index_patterns'
      },
      dataViewId: {
        path: 'data_view_id'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, ({
    type,
    indexPatterns,
    dataViewId
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_source_info_text.DataSourceInfoText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_source_type_selector_field.DataSourceTypeSelectorField, {
    field: type,
    resetForm: resetForm,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(TabContent, {
    visible: type.value === _prebuilt_rules.DataSourceType.index_patterns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_index_pattern_edit.IndexPatternField, {
    key: "index-patterns",
    field: indexPatterns,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(TabContent, {
    visible: type.value === _prebuilt_rules.DataSourceType.data_view,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_data_view_field.DataViewField, {
    key: "data-view",
    field: dataViewId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 15
    }
  })))));
}
const hidden = (0, _css.css)`
  display: none;
`;
function TabContent({
  visible,
  children
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: !visible ? hidden : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 10
    }
  }, children);
}