"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduleRuleRun = useScheduleRuleRun;
var _react = require("react");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var _use_schedule_rule_run_mutation = require("../api/hooks/use_schedule_rule_run_mutation");
var i18n = _interopRequireWildcard(require("../translations"));
var _telemetry = require("../../../common/lib/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useScheduleRuleRun() {
  const {
    mutateAsync
  } = (0, _use_schedule_rule_run_mutation.useScheduleRuleRunMutation)();
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const scheduleRuleRun = (0, _react.useCallback)(async options => {
    try {
      const results = await mutateAsync(options);
      telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunExecute, {
        rangeInMs: options.timeRange.endDate.diff(options.timeRange.startDate),
        status: 'success',
        rulesCount: options.ruleIds.length
      });
      addSuccess(i18n.BACKFILL_SCHEDULE_SUCCESS(results.length));
      return results;
    } catch (error) {
      addError(error, {
        title: i18n.BACKFILL_SCHEDULE_ERROR_TITLE
      });
      telemetry.reportEvent(_telemetry.ManualRuleRunEventTypes.ManualRuleRunExecute, {
        rangeInMs: options.timeRange.endDate.diff(options.timeRange.startDate),
        status: 'error',
        rulesCount: options.ruleIds.length
      });
    }
  }, [addError, addSuccess, mutateAsync, telemetry]);
  return {
    scheduleRuleRun
  };
}