"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackfillStatusInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_gaps/components/rule_backfills_info/backfill_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getBackfillStatusColor(status) {
  switch (status) {
    case 'pending':
      return 'warning';
    case 'running':
      return 'success';
    default:
      return 'subdued';
  }
}
const BackfillStatusInfo = ({
  status
}) => {
  const capitalizedStatus = (0, _lodash.capitalize)(status);
  const color = getBackfillStatusColor(status);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 10
    }
  }, capitalizedStatus);
};
exports.BackfillStatusInfo = BackfillStatusInfo;