"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isPageViewSupported = exports.LoggedRequestsPages = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _optimized_accordion = require("./optimized_accordion");
var _use_accordion_styling = require("./use_accordion_styling");
var _logged_requests_query = require("./logged_requests_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/logged_requests_pages.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ruleRequestsTypesMap = {
  query: {
    findDocuments: 'pageDelimiter'
  },
  saved_query: {
    findDocuments: 'pageDelimiter'
  },
  threshold: {
    findThresholdBuckets: 'pageDelimiter'
  },
  new_terms: {
    findAllTerms: 'pageDelimiter'
  },
  esql: {
    findMatches: 'pageDelimiter'
  }
};
const isPageViewSupported = ruleType => ruleType in ruleRequestsTypesMap;
exports.isPageViewSupported = isPageViewSupported;
const hasRequestType = (ruleType, requestType) => requestType in ruleRequestsTypesMap[ruleType];
const transformRequestsToPages = (requests, ruleType) => {
  const pages = [];
  requests.forEach(request => {
    if (pages.length === 0) {
      pages.push([request]);
    } else if (request.request_type && hasRequestType(ruleType, request.request_type) && ruleRequestsTypesMap[ruleType][request.request_type] === 'pageDelimiter') {
      pages.push([request]);
    } else {
      var _pages$at;
      (_pages$at = pages.at(-1)) === null || _pages$at === void 0 ? void 0 : _pages$at.push(request);
    }
  });
  return pages;
};
const LoggedRequestsPagesComponent = ({
  requests,
  ruleType
}) => {
  const cssStyles = (0, _use_accordion_styling.useAccordionStyling)();
  const paddingLarge = (0, _eui.useEuiPaddingSize)('l');
  const pages = transformRequestsToPages(requests, ruleType);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pages.map((pageRequests, key) => /*#__PURE__*/_react.default.createElement(_optimized_accordion.OptimizedAccordion, {
    key: key,
    id: `preview-logged-requests-page-accordion-${key}`,
    "data-test-subj": "preview-logged-requests-page-accordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.queryPreview.loggedRequestPageLabel",
      defaultMessage: "Page {pageNumber} of search queries",
      values: {
        pageNumber: key + 1
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 13
      }
    }),
    borders: "horizontal",
    css: (0, _react2.css)`
            margin-left: ${paddingLarge};
            ${cssStyles}
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, pageRequests.map((request, requestKey) => /*#__PURE__*/_react.default.createElement(_logged_requests_query.LoggedRequestsQuery, (0, _extends2.default)({
    key: requestKey
  }, request, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }))))));
};
const LoggedRequestsPages = exports.LoggedRequestsPages = /*#__PURE__*/_react.default.memo(LoggedRequestsPagesComponent);
LoggedRequestsPages.displayName = 'LoggedRequestsPages';