"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedIntegrationField = RelatedIntegrationField;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _semver = _interopRequireDefault(require("semver"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _use_integrations = require("../../../common/components/related_integrations/use_integrations");
var _integration_status_badge = require("./integration_status_badge");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/related_integrations/related_integration_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RelatedIntegrationField({
  field,
  relatedIntegrations,
  onRemove
}) {
  var _packageErrorMessage$;
  const {
    data: integrations,
    isInitialLoading
  } = (0, _use_integrations.useIntegrations)();
  const [integrationOptions, selectedIntegrationOptions] = (0, _react.useMemo)(() => {
    var _field$value$integrat, _options$find;
    const currentKey = getKey(field.value.package, field.value.integration);
    const relatedIntegrationsButCurrent = relatedIntegrations.filter(ri => getKey(ri.package, ri.integration) !== currentKey);
    const unusedIntegrations = filterOutUsedIntegrations(integrations !== null && integrations !== void 0 ? integrations : [], relatedIntegrationsButCurrent);
    const options = unusedIntegrations.map(transformIntegrationToOption);
    const fallbackSelectedOption = field.value.package.length > 0 ? {
      key: currentKey,
      label: `${(0, _lodash.capitalize)(field.value.package)} ${(_field$value$integrat = field.value.integration) !== null && _field$value$integrat !== void 0 ? _field$value$integrat : ''}`
    } : undefined;
    const selectedOption = (_options$find = options.find(option => option.key === currentKey)) !== null && _options$find !== void 0 ? _options$find : fallbackSelectedOption;
    return [options, selectedOption ? [selectedOption] : []];
  }, [integrations, field.value, relatedIntegrations]);
  const [packageErrorMessage, versionErrorMessage] = (0, _react.useMemo)(() => {
    const packagePath = `${field.path}.package`;
    const versionPath = `${field.path}.version`;
    return [field.errors.find(err => 'path' in err && err.path === packagePath), field.errors.find(err => 'path' in err && err.path === versionPath)];
  }, [field.path, field.errors]);
  const handleIntegrationChange = (0, _react.useCallback)(([changedSelectedOption]) => {
    var _changedSelectedOptio, _changedSelectedOptio2, _changedSelectedOptio3;
    return field.setValue({
      package: (_changedSelectedOptio = changedSelectedOption === null || changedSelectedOption === void 0 ? void 0 : (_changedSelectedOptio2 = changedSelectedOption.value) === null || _changedSelectedOptio2 === void 0 ? void 0 : _changedSelectedOptio2.package_name) !== null && _changedSelectedOptio !== void 0 ? _changedSelectedOptio : '',
      integration: changedSelectedOption === null || changedSelectedOption === void 0 ? void 0 : (_changedSelectedOptio3 = changedSelectedOption.value) === null || _changedSelectedOptio3 === void 0 ? void 0 : _changedSelectedOptio3.integration_name,
      version: changedSelectedOption !== null && changedSelectedOption !== void 0 && changedSelectedOption.value ? calculateRelevantSemver(changedSelectedOption.value) : ''
    });
  }, [field]);
  const handleVersionChange = (0, _react.useCallback)(e => {
    const version = e.target.value;
    field.setValue(oldValue => ({
      ...oldValue,
      version
    }));
  }, [field]);
  const hasError = Boolean(packageErrorMessage) || Boolean(versionErrorMessage);
  const isVersionInputDisabled = !field.value.package || !integrations;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: hasError,
    error: (_packageErrorMessage$ = packageErrorMessage === null || packageErrorMessage === void 0 ? void 0 : packageErrorMessage.message) !== null && _packageErrorMessage$ !== void 0 ? _packageErrorMessage$ : versionErrorMessage === null || versionErrorMessage === void 0 ? void 0 : versionErrorMessage.message,
    helpText: hasError ? undefined : i18n.RELATED_INTEGRATION_FIELDS_HELP_TEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8,
    className: ROW_OVERFLOW_FIX_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: integrationOptions,
    renderOption: renderIntegrationOption,
    selectedOptions: selectedIntegrationOptions,
    singleSelection: true,
    isLoading: isInitialLoading,
    isDisabled: !integrations,
    onChange: handleIntegrationChange,
    fullWidth: true,
    "aria-label": i18n.RELATED_INTEGRATION_ARIA_LABEL,
    isInvalid: Boolean(packageErrorMessage),
    "data-test-subj": "relatedIntegrationComboBox",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    className: MIN_WIDTH_VERSION_CONSTRAIN_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: isVersionInputDisabled ? '' : i18n.RELATED_INTEGRATION_VERSION_DEPENDENCY_PLACEHOLDER,
    prepend: i18n.INTEGRATION_VERSION,
    isLoading: isInitialLoading,
    disabled: isVersionInputDisabled,
    "aria-label": i18n.RELATED_INTEGRATION_VERSION_DEPENDENCY_ARIA_LABEL,
    value: field.value.version,
    onChange: handleVersionChange,
    isInvalid: Boolean(versionErrorMessage),
    "data-test-subj": "relatedIntegrationVersionDependency",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    onClick: onRemove,
    isDisabled: !integrations,
    iconType: "trash",
    "aria-label": i18n.REMOVE_RELATED_INTEGRATION_BUTTON_ARIA_LABEL,
    "data-test-subj": "relatedIntegrationRemove",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }))));
}
const ROW_OVERFLOW_FIX_STYLE = (0, _css.css)`
  overflow: hidden;
`;

/**
 * Minimum width has been determined empirically like that
 * semver value like `^1.2.3` doesn't overflow
 */
const MIN_WIDTH_VERSION_CONSTRAIN_STYLE = (0, _css.css)`
  min-width: 150px;
`;
function filterOutUsedIntegrations(integrations, relatedIntegrations) {
  const usedIntegrationsSet = new Set(relatedIntegrations.map(ri => getKey(ri.package, ri.integration)));
  return integrations === null || integrations === void 0 ? void 0 : integrations.filter(i => !usedIntegrationsSet.has(getKey(i.package_name, i.integration_name)));
}
function transformIntegrationToOption(integration) {
  var _integration$integrat;
  const integrationTitle = (_integration$integrat = integration.integration_title) !== null && _integration$integrat !== void 0 ? _integration$integrat : integration.package_title;
  const label = integration.is_enabled ? i18n.INTEGRATION_ENABLED(integrationTitle) : integration.is_installed ? i18n.INTEGRATION_DISABLED(integrationTitle) : integrationTitle;
  return {
    key: getKey(integration.package_name, integration.integration_name),
    label,
    value: integration,
    color: integration.is_enabled ? 'success' : integration.is_installed ? 'primary' : undefined
  };
}
function getKey(packageName, integrationName) {
  return `${packageName !== null && packageName !== void 0 ? packageName : ''}${integrationName !== null && integrationName !== void 0 ? integrationName : ''}`;
}
function renderIntegrationOption(option) {
  var _value$integration_ti;
  const {
    label,
    value
  } = option;
  if (!value) {
    return label;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "relatedIntegrationComboBoxOption",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
    text: (_value$integration_ti = value.integration_title) !== null && _value$integration_ti !== void 0 ? _value$integration_ti : value.package_title,
    truncation: "end",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_status_badge.IntegrationStatusBadge, {
    isInstalled: value.is_installed,
    isEnabled: value.is_enabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  })));
}
function calculateRelevantSemver(integration) {
  if (!integration.installed_package_version) {
    return `^${integration.latest_package_version}`;
  }

  // In some rare cases users may install a prerelease integration version.
  // We need to build constraint on the latest stable version and
  // it's supposed `latest_package_version` is the latest stable version.
  if (_semver.default.gt(integration.installed_package_version, integration.latest_package_version)) {
    return `^${integration.latest_package_version}`;
  }
  return `^${integration.installed_package_version}`;
}